@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Accelerator type.
 */
public data class LaunchTemplateElasticInferenceAcceleratorArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateElasticInferenceAcceleratorArgs].
 */
@PulumiTagMarker
public class LaunchTemplateElasticInferenceAcceleratorArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Accelerator type.
     */
    @JvmName("doulgdwuljcllecd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Accelerator type.
     */
    @JvmName("cxiislcpumjjagac")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LaunchTemplateElasticInferenceAcceleratorArgs =
        LaunchTemplateElasticInferenceAcceleratorArgs(
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
