@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the instance profile. Conflicts with `name`.
 * @property name The name of the instance profile.
 */
public data class LaunchTemplateIamInstanceProfileArgs(
    public val arn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateIamInstanceProfileArgs].
 */
@PulumiTagMarker
public class LaunchTemplateIamInstanceProfileArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the instance profile. Conflicts with `name`.
     */
    @JvmName("wdtkyejqkjnxgeuo")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The name of the instance profile.
     */
    @JvmName("vunltwsqdugkowft")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the instance profile. Conflicts with `name`.
     */
    @JvmName("cqpvyldjddackcic")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The name of the instance profile.
     */
    @JvmName("cpveoggtiyoagcvd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LaunchTemplateIamInstanceProfileArgs = LaunchTemplateIamInstanceProfileArgs(
        arn = arn,
        name = name,
    )
}
