@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property marketType The market type. Can be `spot`.
 * @property spotOptions The options for [Spot Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
 */
public data class LaunchTemplateInstanceMarketOptionsArgs(
    public val marketType: Output<String>? = null,
    public val spotOptions: Output<LaunchTemplateInstanceMarketOptionsSpotOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs.builder()
            .marketType(marketType?.applyValue({ args0 -> args0 }))
            .spotOptions(spotOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LaunchTemplateInstanceMarketOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateInstanceMarketOptionsArgsBuilder internal constructor() {
    private var marketType: Output<String>? = null

    private var spotOptions: Output<LaunchTemplateInstanceMarketOptionsSpotOptionsArgs>? = null

    /**
     * @param value The market type. Can be `spot`.
     */
    @JvmName("qnjeirogibyxuujw")
    public suspend fun marketType(`value`: Output<String>) {
        this.marketType = value
    }

    /**
     * @param value The options for [Spot Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
     */
    @JvmName("ucksoqaoyvxsasyx")
    public suspend
    fun spotOptions(`value`: Output<LaunchTemplateInstanceMarketOptionsSpotOptionsArgs>) {
        this.spotOptions = value
    }

    /**
     * @param value The market type. Can be `spot`.
     */
    @JvmName("uukugphjxlpvqxgi")
    public suspend fun marketType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketType = mapped
    }

    /**
     * @param value The options for [Spot Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
     */
    @JvmName("breihddokclijafc")
    public suspend fun spotOptions(`value`: LaunchTemplateInstanceMarketOptionsSpotOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotOptions = mapped
    }

    /**
     * @param argument The options for [Spot Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
     */
    @JvmName("pnkwfldyjbbohgfi")
    public suspend
    fun spotOptions(argument: suspend LaunchTemplateInstanceMarketOptionsSpotOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateInstanceMarketOptionsSpotOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spotOptions = mapped
    }

    internal fun build(): LaunchTemplateInstanceMarketOptionsArgs =
        LaunchTemplateInstanceMarketOptionsArgs(
            marketType = marketType,
            spotOptions = spotOptions,
        )
}
