@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsSpotOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockDurationMinutes The required duration in minutes. This value must be a multiple of 60.
 * @property instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Can be `hibernate`,
 * `stop`, or `terminate`. (Default: `terminate`).
 * @property maxPrice The maximum hourly price you're willing to pay for the Spot Instances.
 * @property spotInstanceType The Spot Instance request type. Can be `one-time`, or `persistent`.
 * @property validUntil The end date of the request.
 */
public data class LaunchTemplateInstanceMarketOptionsSpotOptionsArgs(
    public val blockDurationMinutes: Output<Int>? = null,
    public val instanceInterruptionBehavior: Output<String>? = null,
    public val maxPrice: Output<String>? = null,
    public val spotInstanceType: Output<String>? = null,
    public val validUntil: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsSpotOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsSpotOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsSpotOptionsArgs.builder()
            .blockDurationMinutes(blockDurationMinutes?.applyValue({ args0 -> args0 }))
            .instanceInterruptionBehavior(instanceInterruptionBehavior?.applyValue({ args0 -> args0 }))
            .maxPrice(maxPrice?.applyValue({ args0 -> args0 }))
            .spotInstanceType(spotInstanceType?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateInstanceMarketOptionsSpotOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateInstanceMarketOptionsSpotOptionsArgsBuilder internal constructor() {
    private var blockDurationMinutes: Output<Int>? = null

    private var instanceInterruptionBehavior: Output<String>? = null

    private var maxPrice: Output<String>? = null

    private var spotInstanceType: Output<String>? = null

    private var validUntil: Output<String>? = null

    /**
     * @param value The required duration in minutes. This value must be a multiple of 60.
     */
    @JvmName("ccyvvsswaorrlgtu")
    public suspend fun blockDurationMinutes(`value`: Output<Int>) {
        this.blockDurationMinutes = value
    }

    /**
     * @param value The behavior when a Spot Instance is interrupted. Can be `hibernate`,
     * `stop`, or `terminate`. (Default: `terminate`).
     */
    @JvmName("vsomhkcsfebagwfd")
    public suspend fun instanceInterruptionBehavior(`value`: Output<String>) {
        this.instanceInterruptionBehavior = value
    }

    /**
     * @param value The maximum hourly price you're willing to pay for the Spot Instances.
     */
    @JvmName("vxjykdcqobgektun")
    public suspend fun maxPrice(`value`: Output<String>) {
        this.maxPrice = value
    }

    /**
     * @param value The Spot Instance request type. Can be `one-time`, or `persistent`.
     */
    @JvmName("cfioepbbbeujnbad")
    public suspend fun spotInstanceType(`value`: Output<String>) {
        this.spotInstanceType = value
    }

    /**
     * @param value The end date of the request.
     */
    @JvmName("sbkuogobwqskwnei")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value The required duration in minutes. This value must be a multiple of 60.
     */
    @JvmName("bdxutfrvyxadofvy")
    public suspend fun blockDurationMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDurationMinutes = mapped
    }

    /**
     * @param value The behavior when a Spot Instance is interrupted. Can be `hibernate`,
     * `stop`, or `terminate`. (Default: `terminate`).
     */
    @JvmName("ixjaptwbgvuiewdi")
    public suspend fun instanceInterruptionBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInterruptionBehavior = mapped
    }

    /**
     * @param value The maximum hourly price you're willing to pay for the Spot Instances.
     */
    @JvmName("eukmwvxsybqiqxki")
    public suspend fun maxPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrice = mapped
    }

    /**
     * @param value The Spot Instance request type. Can be `one-time`, or `persistent`.
     */
    @JvmName("imjocuacrghiiban")
    public suspend fun spotInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceType = mapped
    }

    /**
     * @param value The end date of the request.
     */
    @JvmName("gavklypeusmpiqhr")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    internal fun build(): LaunchTemplateInstanceMarketOptionsSpotOptionsArgs =
        LaunchTemplateInstanceMarketOptionsSpotOptionsArgs(
            blockDurationMinutes = blockDurationMinutes,
            instanceInterruptionBehavior = instanceInterruptionBehavior,
            maxPrice = maxPrice,
            spotInstanceType = spotInstanceType,
            validUntil = validUntil,
        )
}
