@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsAcceleratorCountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max Maximum.
 * @property min Minimum.
 */
public data class LaunchTemplateInstanceRequirementsAcceleratorCountArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsAcceleratorCountArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsAcceleratorCountArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsAcceleratorCountArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateInstanceRequirementsAcceleratorCountArgs].
 */
@PulumiTagMarker
public class LaunchTemplateInstanceRequirementsAcceleratorCountArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value Maximum.
     */
    @JvmName("rroyxxpkhrqkmwil")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value Minimum.
     */
    @JvmName("hjfybcrndepnvrgx")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value Maximum.
     */
    @JvmName("asrngdnwigawvelb")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value Minimum.
     */
    @JvmName("elqbsfodekdtrkov")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): LaunchTemplateInstanceRequirementsAcceleratorCountArgs =
        LaunchTemplateInstanceRequirementsAcceleratorCountArgs(
            max = max,
            min = min,
        )
}
