@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max Maximum.
 * @property min Minimum.
 */
public data class LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs(
    public val max: Output<Double>? = null,
    public val min: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs].
 */
@PulumiTagMarker
public class LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgsBuilder internal constructor() {
    private var max: Output<Double>? = null

    private var min: Output<Double>? = null

    /**
     * @param value Maximum.
     */
    @JvmName("tjwbskonsgfgjrrh")
    public suspend fun max(`value`: Output<Double>) {
        this.max = value
    }

    /**
     * @param value Minimum.
     */
    @JvmName("qbakjaqfsmoqapfl")
    public suspend fun min(`value`: Output<Double>) {
        this.min = value
    }

    /**
     * @param value Maximum.
     */
    @JvmName("ulrrfwhdhikhafjr")
    public suspend fun max(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value Minimum.
     */
    @JvmName("obvcsgmrltgusgki")
    public suspend fun min(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs =
        LaunchTemplateInstanceRequirementsMemoryGibPerVcpuArgs(
            max = max,
            min = min,
        )
}
