@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property licenseConfigurationArn ARN of the license configuration.
 */
public data class LaunchTemplateLicenseSpecificationArgs(
    public val licenseConfigurationArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs.builder()
            .licenseConfigurationArn(licenseConfigurationArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateLicenseSpecificationArgs].
 */
@PulumiTagMarker
public class LaunchTemplateLicenseSpecificationArgsBuilder internal constructor() {
    private var licenseConfigurationArn: Output<String>? = null

    /**
     * @param value ARN of the license configuration.
     */
    @JvmName("inaojeihbitsekiy")
    public suspend fun licenseConfigurationArn(`value`: Output<String>) {
        this.licenseConfigurationArn = value
    }

    /**
     * @param value ARN of the license configuration.
     */
    @JvmName("xvjgvnsadslprslx")
    public suspend fun licenseConfigurationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseConfigurationArn = mapped
    }

    internal fun build(): LaunchTemplateLicenseSpecificationArgs =
        LaunchTemplateLicenseSpecificationArgs(
            licenseConfigurationArn = licenseConfigurationArn ?: throw
                PulumiNullFieldException("licenseConfigurationArn"),
        )
}
