@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property associateCarrierIpAddress Associate a Carrier IP address with `eth0` for a new network interface.
 * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface.
 * Boolean value, can be left unset.
 * @property associatePublicIpAddress Associate a public ip address with the network interface.
 * Boolean value, can be left unset.
 * @property deleteOnTermination Whether the network interface should be destroyed on instance termination.
 * @property description Description of the network interface.
 * @property deviceIndex The integer index of the network interface attachment.
 * @property interfaceType The type of network interface. To create an Elastic Fabric Adapter (EFA), specify `efa`.
 * @property ipv4AddressCount The number of secondary private IPv4 addresses to assign to a network interface. Conflicts with `ipv4_addresses`
 * @property ipv4Addresses One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
 * @property ipv4PrefixCount The number of IPv4 prefixes to be automatically assigned to the network interface. Conflicts with `ipv4_prefixes`
 * @property ipv4Prefixes One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
 * @property ipv6AddressCount The number of IPv6 addresses to assign to a network interface. Conflicts with `ipv6_addresses`
 * @property ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
 * @property ipv6PrefixCount The number of IPv6 prefixes to be automatically assigned to the network interface. Conflicts with `ipv6_prefixes`
 * @property ipv6Prefixes One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
 * @property networkCardIndex The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
 * @property networkInterfaceId The ID of the network interface to attach.
 * @property privateIpAddress The primary private IPv4 address.
 * @property securityGroups A list of security group IDs to associate.
 * @property subnetId The VPC Subnet ID to associate.
 */
public data class LaunchTemplateNetworkInterfaceArgs(
    public val associateCarrierIpAddress: Output<String>? = null,
    public val associatePublicIpAddress: Output<String>? = null,
    public val deleteOnTermination: Output<String>? = null,
    public val description: Output<String>? = null,
    public val deviceIndex: Output<Int>? = null,
    public val interfaceType: Output<String>? = null,
    public val ipv4AddressCount: Output<Int>? = null,
    public val ipv4Addresses: Output<List<String>>? = null,
    public val ipv4PrefixCount: Output<Int>? = null,
    public val ipv4Prefixes: Output<List<String>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    public val ipv6PrefixCount: Output<Int>? = null,
    public val ipv6Prefixes: Output<List<String>>? = null,
    public val networkCardIndex: Output<Int>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs.builder()
            .associateCarrierIpAddress(associateCarrierIpAddress?.applyValue({ args0 -> args0 }))
            .associatePublicIpAddress(associatePublicIpAddress?.applyValue({ args0 -> args0 }))
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceIndex(deviceIndex?.applyValue({ args0 -> args0 }))
            .interfaceType(interfaceType?.applyValue({ args0 -> args0 }))
            .ipv4AddressCount(ipv4AddressCount?.applyValue({ args0 -> args0 }))
            .ipv4Addresses(ipv4Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv4PrefixCount(ipv4PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv4Prefixes(ipv4Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6PrefixCount(ipv6PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv6Prefixes(ipv6Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkCardIndex(networkCardIndex?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateNetworkInterfaceArgs].
 */
@PulumiTagMarker
public class LaunchTemplateNetworkInterfaceArgsBuilder internal constructor() {
    private var associateCarrierIpAddress: Output<String>? = null

    private var associatePublicIpAddress: Output<String>? = null

    private var deleteOnTermination: Output<String>? = null

    private var description: Output<String>? = null

    private var deviceIndex: Output<Int>? = null

    private var interfaceType: Output<String>? = null

    private var ipv4AddressCount: Output<Int>? = null

    private var ipv4Addresses: Output<List<String>>? = null

    private var ipv4PrefixCount: Output<Int>? = null

    private var ipv4Prefixes: Output<List<String>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var ipv6PrefixCount: Output<Int>? = null

    private var ipv6Prefixes: Output<List<String>>? = null

    private var networkCardIndex: Output<Int>? = null

    private var networkInterfaceId: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Associate a Carrier IP address with `eth0` for a new network interface.
     * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface.
     * Boolean value, can be left unset.
     */
    @JvmName("hdmglxacspxwawps")
    public suspend fun associateCarrierIpAddress(`value`: Output<String>) {
        this.associateCarrierIpAddress = value
    }

    /**
     * @param value Associate a public ip address with the network interface.
     * Boolean value, can be left unset.
     */
    @JvmName("tmjgiiywiwdwvwje")
    public suspend fun associatePublicIpAddress(`value`: Output<String>) {
        this.associatePublicIpAddress = value
    }

    /**
     * @param value Whether the network interface should be destroyed on instance termination.
     */
    @JvmName("haxxrmkgjqdfjsfx")
    public suspend fun deleteOnTermination(`value`: Output<String>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Description of the network interface.
     */
    @JvmName("huggcjgwhrvjhurk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The integer index of the network interface attachment.
     */
    @JvmName("syijsyaoikttbcos")
    public suspend fun deviceIndex(`value`: Output<Int>) {
        this.deviceIndex = value
    }

    /**
     * @param value The type of network interface. To create an Elastic Fabric Adapter (EFA), specify `efa`.
     */
    @JvmName("lajbwptctokidouj")
    public suspend fun interfaceType(`value`: Output<String>) {
        this.interfaceType = value
    }

    /**
     * @param value The number of secondary private IPv4 addresses to assign to a network interface. Conflicts with `ipv4_addresses`
     */
    @JvmName("ptrqfxoqteloedaj")
    public suspend fun ipv4AddressCount(`value`: Output<Int>) {
        this.ipv4AddressCount = value
    }

    /**
     * @param value One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
     */
    @JvmName("qtbjtvwuvghmboah")
    public suspend fun ipv4Addresses(`value`: Output<List<String>>) {
        this.ipv4Addresses = value
    }

    @JvmName("wihgxsnvftgosdxr")
    public suspend fun ipv4Addresses(vararg values: Output<String>) {
        this.ipv4Addresses = Output.all(values.asList())
    }

    /**
     * @param values One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
     */
    @JvmName("usvlqkyfqywhghhd")
    public suspend fun ipv4Addresses(values: List<Output<String>>) {
        this.ipv4Addresses = Output.all(values)
    }

    /**
     * @param value The number of IPv4 prefixes to be automatically assigned to the network interface. Conflicts with `ipv4_prefixes`
     */
    @JvmName("shecfqxvdoyvrlsf")
    public suspend fun ipv4PrefixCount(`value`: Output<Int>) {
        this.ipv4PrefixCount = value
    }

    /**
     * @param value One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
     */
    @JvmName("nrdfofyqqboqpkfr")
    public suspend fun ipv4Prefixes(`value`: Output<List<String>>) {
        this.ipv4Prefixes = value
    }

    @JvmName("gfhsobxvmmgrnmcq")
    public suspend fun ipv4Prefixes(vararg values: Output<String>) {
        this.ipv4Prefixes = Output.all(values.asList())
    }

    /**
     * @param values One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
     */
    @JvmName("fdjkikceqfckvxmb")
    public suspend fun ipv4Prefixes(values: List<Output<String>>) {
        this.ipv4Prefixes = Output.all(values)
    }

    /**
     * @param value The number of IPv6 addresses to assign to a network interface. Conflicts with `ipv6_addresses`
     */
    @JvmName("gjxhtodrsetyxdvq")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
     */
    @JvmName("xuqweltqgkrxylmh")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("mcqecqpptgtbhcbe")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
     */
    @JvmName("vfbdfiegsethjxje")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value The number of IPv6 prefixes to be automatically assigned to the network interface. Conflicts with `ipv6_prefixes`
     */
    @JvmName("hdyosqfbukpcbpge")
    public suspend fun ipv6PrefixCount(`value`: Output<Int>) {
        this.ipv6PrefixCount = value
    }

    /**
     * @param value One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
     */
    @JvmName("ibffjwwihxyfgkdv")
    public suspend fun ipv6Prefixes(`value`: Output<List<String>>) {
        this.ipv6Prefixes = value
    }

    @JvmName("qymoxunytlgxmtpo")
    public suspend fun ipv6Prefixes(vararg values: Output<String>) {
        this.ipv6Prefixes = Output.all(values.asList())
    }

    /**
     * @param values One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
     */
    @JvmName("pswpieermtmcutgk")
    public suspend fun ipv6Prefixes(values: List<Output<String>>) {
        this.ipv6Prefixes = Output.all(values)
    }

    /**
     * @param value The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
     */
    @JvmName("gmavnpxasrftetgd")
    public suspend fun networkCardIndex(`value`: Output<Int>) {
        this.networkCardIndex = value
    }

    /**
     * @param value The ID of the network interface to attach.
     */
    @JvmName("vcvouctetmpcjrgl")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The primary private IPv4 address.
     */
    @JvmName("fmvaqlfsojbcrciu")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value A list of security group IDs to associate.
     */
    @JvmName("mckoejluyacusehw")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("gkmhkjdwvrwllllh")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to associate.
     */
    @JvmName("vdrdhmdwfnxtnecj")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The VPC Subnet ID to associate.
     */
    @JvmName("itpoouamthkrwdmx")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Associate a Carrier IP address with `eth0` for a new network interface.
     * Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface.
     * Boolean value, can be left unset.
     */
    @JvmName("vsxgpsdciounfeyt")
    public suspend fun associateCarrierIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateCarrierIpAddress = mapped
    }

    /**
     * @param value Associate a public ip address with the network interface.
     * Boolean value, can be left unset.
     */
    @JvmName("tmfwvqejxhrnvuwc")
    public suspend fun associatePublicIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatePublicIpAddress = mapped
    }

    /**
     * @param value Whether the network interface should be destroyed on instance termination.
     */
    @JvmName("iuqwgwlodkhfogop")
    public suspend fun deleteOnTermination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Description of the network interface.
     */
    @JvmName("aualdcmtsphiuirb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The integer index of the network interface attachment.
     */
    @JvmName("sckdgkljyfrgcgdd")
    public suspend fun deviceIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceIndex = mapped
    }

    /**
     * @param value The type of network interface. To create an Elastic Fabric Adapter (EFA), specify `efa`.
     */
    @JvmName("wkwvwpsqgmnfuxlb")
    public suspend fun interfaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceType = mapped
    }

    /**
     * @param value The number of secondary private IPv4 addresses to assign to a network interface. Conflicts with `ipv4_addresses`
     */
    @JvmName("aqjnytldptuwfrmc")
    public suspend fun ipv4AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4AddressCount = mapped
    }

    /**
     * @param value One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
     */
    @JvmName("cbxthfwpkygxtgol")
    public suspend fun ipv4Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Addresses = mapped
    }

    /**
     * @param values One or more private IPv4 addresses to associate. Conflicts with `ipv4_address_count`
     */
    @JvmName("msiyqokdahtafvyj")
    public suspend fun ipv4Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Addresses = mapped
    }

    /**
     * @param value The number of IPv4 prefixes to be automatically assigned to the network interface. Conflicts with `ipv4_prefixes`
     */
    @JvmName("mtpmmcktowhuimnp")
    public suspend fun ipv4PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4PrefixCount = mapped
    }

    /**
     * @param value One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
     */
    @JvmName("djrnydumumthdool")
    public suspend fun ipv4Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param values One or more IPv4 prefixes to be assigned to the network interface. Conflicts with `ipv4_prefix_count`
     */
    @JvmName("inpfajadvllpefqm")
    public suspend fun ipv4Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param value The number of IPv6 addresses to assign to a network interface. Conflicts with `ipv6_addresses`
     */
    @JvmName("sjugljoexdxrrrcr")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
     */
    @JvmName("esvvjxqbsgcblrmw")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Conflicts with `ipv6_address_count`
     */
    @JvmName("ndtnyxghcbgrmssy")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value The number of IPv6 prefixes to be automatically assigned to the network interface. Conflicts with `ipv6_prefixes`
     */
    @JvmName("eirwhspdtylkusab")
    public suspend fun ipv6PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6PrefixCount = mapped
    }

    /**
     * @param value One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
     */
    @JvmName("cynxygpfvxufowrf")
    public suspend fun ipv6Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Prefixes = mapped
    }

    /**
     * @param values One or more IPv6 prefixes to be assigned to the network interface. Conflicts with `ipv6_prefix_count`
     */
    @JvmName("ymfjgoftlchsvoad")
    public suspend fun ipv6Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Prefixes = mapped
    }

    /**
     * @param value The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
     */
    @JvmName("baweogkankjwcdxa")
    public suspend fun networkCardIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCardIndex = mapped
    }

    /**
     * @param value The ID of the network interface to attach.
     */
    @JvmName("vfexniegwegenemp")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The primary private IPv4 address.
     */
    @JvmName("adksyvladxgiutau")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value A list of security group IDs to associate.
     */
    @JvmName("wnuonmjnsgboxcgk")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs to associate.
     */
    @JvmName("qdcvyotelfheagfq")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The VPC Subnet ID to associate.
     */
    @JvmName("qlradgsbnwgqqcpt")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): LaunchTemplateNetworkInterfaceArgs = LaunchTemplateNetworkInterfaceArgs(
        associateCarrierIpAddress = associateCarrierIpAddress,
        associatePublicIpAddress = associatePublicIpAddress,
        deleteOnTermination = deleteOnTermination,
        description = description,
        deviceIndex = deviceIndex,
        interfaceType = interfaceType,
        ipv4AddressCount = ipv4AddressCount,
        ipv4Addresses = ipv4Addresses,
        ipv4PrefixCount = ipv4PrefixCount,
        ipv4Prefixes = ipv4Prefixes,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        ipv6PrefixCount = ipv6PrefixCount,
        ipv6Prefixes = ipv6Prefixes,
        networkCardIndex = networkCardIndex,
        networkInterfaceId = networkInterfaceId,
        privateIpAddress = privateIpAddress,
        securityGroups = securityGroups,
        subnetId = subnetId,
    )
}
