@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property affinity The affinity setting for an instance on a Dedicated Host.
 * @property availabilityZone The Availability Zone for the instance.
 * @property groupName The name of the placement group for the instance.
 * @property hostId The ID of the Dedicated Host for the instance.
 * @property hostResourceGroupArn The ARN of the Host Resource Group in which to launch instances.
 * @property partitionNumber The number of the partition the instance should launch in. Valid only if the placement group strategy is set to partition.
 * @property spreadDomain Reserved for future use.
 * @property tenancy The tenancy of the instance (if the instance is running in a VPC). Can be `default`, `dedicated`, or `host`.
 */
public data class LaunchTemplatePlacementArgs(
    public val affinity: Output<String>? = null,
    public val availabilityZone: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val hostId: Output<String>? = null,
    public val hostResourceGroupArn: Output<String>? = null,
    public val partitionNumber: Output<Int>? = null,
    public val spreadDomain: Output<String>? = null,
    public val tenancy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs.builder()
            .affinity(affinity?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .hostId(hostId?.applyValue({ args0 -> args0 }))
            .hostResourceGroupArn(hostResourceGroupArn?.applyValue({ args0 -> args0 }))
            .partitionNumber(partitionNumber?.applyValue({ args0 -> args0 }))
            .spreadDomain(spreadDomain?.applyValue({ args0 -> args0 }))
            .tenancy(tenancy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplatePlacementArgs].
 */
@PulumiTagMarker
public class LaunchTemplatePlacementArgsBuilder internal constructor() {
    private var affinity: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var groupName: Output<String>? = null

    private var hostId: Output<String>? = null

    private var hostResourceGroupArn: Output<String>? = null

    private var partitionNumber: Output<Int>? = null

    private var spreadDomain: Output<String>? = null

    private var tenancy: Output<String>? = null

    /**
     * @param value The affinity setting for an instance on a Dedicated Host.
     */
    @JvmName("squfpngdauttdmpa")
    public suspend fun affinity(`value`: Output<String>) {
        this.affinity = value
    }

    /**
     * @param value The Availability Zone for the instance.
     */
    @JvmName("gtmnsxrojtxhyvuk")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The name of the placement group for the instance.
     */
    @JvmName("apocmgvcwffxfhct")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The ID of the Dedicated Host for the instance.
     */
    @JvmName("flihqcbfcyrqrnqv")
    public suspend fun hostId(`value`: Output<String>) {
        this.hostId = value
    }

    /**
     * @param value The ARN of the Host Resource Group in which to launch instances.
     */
    @JvmName("butbpllkbskplaqo")
    public suspend fun hostResourceGroupArn(`value`: Output<String>) {
        this.hostResourceGroupArn = value
    }

    /**
     * @param value The number of the partition the instance should launch in. Valid only if the placement group strategy is set to partition.
     */
    @JvmName("obxuxomexinolueq")
    public suspend fun partitionNumber(`value`: Output<Int>) {
        this.partitionNumber = value
    }

    /**
     * @param value Reserved for future use.
     */
    @JvmName("skyqpajxwmawivhm")
    public suspend fun spreadDomain(`value`: Output<String>) {
        this.spreadDomain = value
    }

    /**
     * @param value The tenancy of the instance (if the instance is running in a VPC). Can be `default`, `dedicated`, or `host`.
     */
    @JvmName("ynbhemshswjlvhka")
    public suspend fun tenancy(`value`: Output<String>) {
        this.tenancy = value
    }

    /**
     * @param value The affinity setting for an instance on a Dedicated Host.
     */
    @JvmName("uckwtennmdfotktq")
    public suspend fun affinity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.affinity = mapped
    }

    /**
     * @param value The Availability Zone for the instance.
     */
    @JvmName("uljamoggspcrcdia")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The name of the placement group for the instance.
     */
    @JvmName("mmfebawuhtpyqysu")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The ID of the Dedicated Host for the instance.
     */
    @JvmName("uriyvhspeasqdugi")
    public suspend fun hostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostId = mapped
    }

    /**
     * @param value The ARN of the Host Resource Group in which to launch instances.
     */
    @JvmName("kkytwkchnjnlsnia")
    public suspend fun hostResourceGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostResourceGroupArn = mapped
    }

    /**
     * @param value The number of the partition the instance should launch in. Valid only if the placement group strategy is set to partition.
     */
    @JvmName("usqbfhlecmewklca")
    public suspend fun partitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNumber = mapped
    }

    /**
     * @param value Reserved for future use.
     */
    @JvmName("nwqxfkyawlqnhfco")
    public suspend fun spreadDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spreadDomain = mapped
    }

    /**
     * @param value The tenancy of the instance (if the instance is running in a VPC). Can be `default`, `dedicated`, or `host`.
     */
    @JvmName("ubpuaphehfpcglof")
    public suspend fun tenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    internal fun build(): LaunchTemplatePlacementArgs = LaunchTemplatePlacementArgs(
        affinity = affinity,
        availabilityZone = availabilityZone,
        groupName = groupName,
        hostId = hostId,
        hostResourceGroupArn = hostResourceGroupArn,
        partitionNumber = partitionNumber,
        spreadDomain = spreadDomain,
        tenancy = tenancy,
    )
}
