@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property resourceType The type of resource to tag.
 * @property tags A map of tags to assign to the resource.
 */
public data class LaunchTemplateTagSpecificationArgs(
    public val resourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs.builder()
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LaunchTemplateTagSpecificationArgs].
 */
@PulumiTagMarker
public class LaunchTemplateTagSpecificationArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The type of resource to tag.
     */
    @JvmName("wrilcttjxkyxykrk")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource.
     */
    @JvmName("cvigcfwmfqckbgrq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of resource to tag.
     */
    @JvmName("cqaelgyjthrwqyna")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource.
     */
    @JvmName("sbaoiwaiuexocwlv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource.
     */
    @JvmName("hfstgsnjixhchvlx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LaunchTemplateTagSpecificationArgs = LaunchTemplateTagSpecificationArgs(
        resourceType = resourceType,
        tags = tags,
    )
}
