@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidr CIDR block of this entry.
 * @property description Description of this entry. Due to API limitations, updating only the description of an existing entry requires temporarily removing and re-adding the entry.
 */
public data class ManagedPrefixListEntryArgs(
    public val cidr: Output<String>,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs =
        com.pulumi.aws.ec2.inputs.ManagedPrefixListEntryArgs.builder()
            .cidr(cidr.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrefixListEntryArgs].
 */
@PulumiTagMarker
public class ManagedPrefixListEntryArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("pspuxkwcsjkvkrcl")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value Description of this entry. Due to API limitations, updating only the description of an existing entry requires temporarily removing and re-adding the entry.
     */
    @JvmName("ullchsnecgqdfsci")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("cgvvbhwybnenbvkb")
    public suspend fun cidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value Description of this entry. Due to API limitations, updating only the description of an existing entry requires temporarily removing and re-adding the entry.
     */
    @JvmName("dekglisgxjanctsm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): ManagedPrefixListEntryArgs = ManagedPrefixListEntryArgs(
        cidr = cidr ?: throw PulumiNullFieldException("cidr"),
        description = description,
    )
}
