@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlocks List of CIDR blocks.
 * @property description Description of this egress rule.
 * @property fromPort Start port (or ICMP type number if protocol is `icmp`)
 * @property ipv6CidrBlocks List of IPv6 CIDR blocks.
 * @property prefixListIds List of Prefix List IDs.
 * @property protocol Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0.  The supported values are defined in the `IpProtocol` argument in the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
 * @property securityGroups List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
 * @property self Whether the security group itself will be added as a source to this egress rule.
 * @property toPort End range port (or ICMP code if protocol is `icmp`).
 * The following arguments are optional:
 * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the destination of the traffic.
 */
public data class SecurityGroupEgressArgs(
    public val cidrBlocks: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>,
    public val ipv6CidrBlocks: Output<List<String>>? = null,
    public val prefixListIds: Output<List<String>>? = null,
    public val protocol: Output<String>,
    public val securityGroups: Output<List<String>>? = null,
    public val self: Output<Boolean>? = null,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs =
        com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs.builder()
            .cidrBlocks(cidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .ipv6CidrBlocks(ipv6CidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixListIds(prefixListIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .self(self?.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupEgressArgs].
 */
@PulumiTagMarker
public class SecurityGroupEgressArgsBuilder internal constructor() {
    private var cidrBlocks: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipv6CidrBlocks: Output<List<String>>? = null

    private var prefixListIds: Output<List<String>>? = null

    private var protocol: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var self: Output<Boolean>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value List of CIDR blocks.
     */
    @JvmName("qaagnlecnannrblv")
    public suspend fun cidrBlocks(`value`: Output<List<String>>) {
        this.cidrBlocks = value
    }

    @JvmName("sflrmdavcjkckufb")
    public suspend fun cidrBlocks(vararg values: Output<String>) {
        this.cidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of CIDR blocks.
     */
    @JvmName("lfptopdurekwirfj")
    public suspend fun cidrBlocks(values: List<Output<String>>) {
        this.cidrBlocks = Output.all(values)
    }

    /**
     * @param value Description of this egress rule.
     */
    @JvmName("bgxufggbiqujojwr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Start port (or ICMP type number if protocol is `icmp`)
     */
    @JvmName("cqhhhavjyroloydr")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value List of IPv6 CIDR blocks.
     */
    @JvmName("vstmnpfnnavdpeox")
    public suspend fun ipv6CidrBlocks(`value`: Output<List<String>>) {
        this.ipv6CidrBlocks = value
    }

    @JvmName("gpuaoxafxotwbbky")
    public suspend fun ipv6CidrBlocks(vararg values: Output<String>) {
        this.ipv6CidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of IPv6 CIDR blocks.
     */
    @JvmName("lrsuseomlbynflth")
    public suspend fun ipv6CidrBlocks(values: List<Output<String>>) {
        this.ipv6CidrBlocks = Output.all(values)
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("decpotxftndhbxta")
    public suspend fun prefixListIds(`value`: Output<List<String>>) {
        this.prefixListIds = value
    }

    @JvmName("ldfvlavbsmsfydrh")
    public suspend fun prefixListIds(vararg values: Output<String>) {
        this.prefixListIds = Output.all(values.asList())
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("rqnlmsfkcgcpnvrs")
    public suspend fun prefixListIds(values: List<Output<String>>) {
        this.prefixListIds = Output.all(values)
    }

    /**
     * @param value Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0.  The supported values are defined in the `IpProtocol` argument in the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
     */
    @JvmName("gapuckbomhnxqjbg")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("ujspamwnmtkxofou")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("svarcspxqqtpfpun")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("fwwrryduitqrryye")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Whether the security group itself will be added as a source to this egress rule.
     */
    @JvmName("opeoqmprujvcxsyq")
    public suspend fun self(`value`: Output<Boolean>) {
        this.self = value
    }

    /**
     * @param value End range port (or ICMP code if protocol is `icmp`).
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the destination of the traffic.
     */
    @JvmName("tbwdasunhfpgooke")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value List of CIDR blocks.
     */
    @JvmName("gmbqluohxcbuevoi")
    public suspend fun cidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param values List of CIDR blocks.
     */
    @JvmName("yydhrhqmdloeexbp")
    public suspend fun cidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param value Description of this egress rule.
     */
    @JvmName("nevesrfaduliprga")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Start port (or ICMP type number if protocol is `icmp`)
     */
    @JvmName("lrhhjjdfjeipbvfa")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value List of IPv6 CIDR blocks.
     */
    @JvmName("radrjhhvqlwvwosd")
    public suspend fun ipv6CidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param values List of IPv6 CIDR blocks.
     */
    @JvmName("kajndkwvocbvojdc")
    public suspend fun ipv6CidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("ainwjnvohyuvgpta")
    public suspend fun prefixListIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("byxydevxsiqruwyl")
    public suspend fun prefixListIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param value Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0.  The supported values are defined in the `IpProtocol` argument in the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
     */
    @JvmName("jcydfvkioxipskyy")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("onfvklofejsxuxvv")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("njdwvrmuoscxmsnj")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Whether the security group itself will be added as a source to this egress rule.
     */
    @JvmName("prulfkigxptueyav")
    public suspend fun self(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.self = mapped
    }

    /**
     * @param value End range port (or ICMP code if protocol is `icmp`).
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the destination of the traffic.
     */
    @JvmName("grpopnnlwnaqdswq")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupEgressArgs = SecurityGroupEgressArgs(
        cidrBlocks = cidrBlocks,
        description = description,
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        ipv6CidrBlocks = ipv6CidrBlocks,
        prefixListIds = prefixListIds,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        securityGroups = securityGroups,
        self = self,
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
