@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName
 * @property virtualName
 */
public data class SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>,
    public val virtualName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .virtualName(virtualName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder internal
constructor() {
    private var deviceName: Output<String>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fpbdvkjmigjynbta")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("rwddikpousjktobi")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value
     */
    @JvmName("lxqtcylvkhumbkpg")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("elkwlmvefxqasyis")
    public suspend fun virtualName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs =
        SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs(
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            virtualName = virtualName ?: throw PulumiNullFieldException("virtualName"),
        )
}
