@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the launch template. Conflicts with `name`.
 * @property name The name of the launch template. Conflicts with `id`.
 * @property version Template version. Unlike the autoscaling equivalent, does not support `$Latest` or `$Default`, so use the launch_template resource's attribute, e.g., `"${aws_launch_template.foo.latest_version}"`. It will use the default version if omitted.
 * **Note:** The specified launch template can specify only a subset of the
 * inputs of `aws.ec2.LaunchTemplate`.  There are limitations on
 * what you can specify as spot fleet does not support all the attributes that are supported by autoscaling groups. [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#launch-templates-spot-fleet) is currently sparse, but at least `instance_initiated_shutdown_behavior` is confirmed unsupported.
 */
public data class SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder internal
constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The ID of the launch template. Conflicts with `name`.
     */
    @JvmName("cpljjacnuoolxjvr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the launch template. Conflicts with `id`.
     */
    @JvmName("vcjocndncgtnkcrc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Template version. Unlike the autoscaling equivalent, does not support `$Latest` or `$Default`, so use the launch_template resource's attribute, e.g., `"${aws_launch_template.foo.latest_version}"`. It will use the default version if omitted.
     * **Note:** The specified launch template can specify only a subset of the
     * inputs of `aws.ec2.LaunchTemplate`.  There are limitations on
     * what you can specify as spot fleet does not support all the attributes that are supported by autoscaling groups. [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#launch-templates-spot-fleet) is currently sparse, but at least `instance_initiated_shutdown_behavior` is confirmed unsupported.
     */
    @JvmName("pwjdbajuawfpqqns")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The ID of the launch template. Conflicts with `name`.
     */
    @JvmName("vktocwmpajosgmgg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the launch template. Conflicts with `id`.
     */
    @JvmName("aboffxknqyesrrmw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Template version. Unlike the autoscaling equivalent, does not support `$Latest` or `$Default`, so use the launch_template resource's attribute, e.g., `"${aws_launch_template.foo.latest_version}"`. It will use the default version if omitted.
     * **Note:** The specified launch template can specify only a subset of the
     * inputs of `aws.ec2.LaunchTemplate`.  There are limitations on
     * what you can specify as spot fleet does not support all the attributes that are supported by autoscaling groups. [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#launch-templates-spot-fleet) is currently sparse, but at least `instance_initiated_shutdown_behavior` is confirmed unsupported.
     */
    @JvmName("bljoabvghjfncbjf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs =
        SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs(
            id = id,
            name = name,
            version = version,
        )
}
