@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property acceleratorCount Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
 * @property acceleratorManufacturers List of accelerator manufacturer names. Default is any manufacturer.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property acceleratorNames List of accelerator names. Default is any acclerator.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property acceleratorTotalMemoryMib Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
 * @property acceleratorTypes List of accelerator types. Default is any accelerator type.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property allowedInstanceTypes List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
 * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
 * @property bareMetal Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property baselineEbsBandwidthMbps Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
 * @property burstablePerformance Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property cpuManufacturers List of CPU manufacturer names. Default is any manufacturer.
 * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property excludedInstanceTypes List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
 * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
 * @property instanceGenerations List of instance generation names. Default is any generation.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property localStorage Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
 * @property localStorageTypes List of local storage type names. Default any storage type.
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property memoryGibPerVcpu Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
 * @property memoryMib Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
 * @property networkBandwidthGbps Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
 * @property networkInterfaceCount Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
 * @property onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property requireHibernateSupport Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
 * @property spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property totalLocalStorageGb Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
 * @property vcpuCount Block describing the minimum and maximum number of vCPUs. Default is no maximum.
 */
public data class SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs(
    public val acceleratorCount:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null,
    public val acceleratorManufacturers: Output<List<String>>? = null,
    public val acceleratorNames: Output<List<String>>? = null,
    public val acceleratorTotalMemoryMib:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null,
    public val acceleratorTypes: Output<List<String>>? = null,
    public val allowedInstanceTypes: Output<List<String>>? = null,
    public val bareMetal: Output<String>? = null,
    public val baselineEbsBandwidthMbps:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null,
    public val burstablePerformance: Output<String>? = null,
    public val cpuManufacturers: Output<List<String>>? = null,
    public val excludedInstanceTypes: Output<List<String>>? = null,
    public val instanceGenerations: Output<List<String>>? = null,
    public val localStorage: Output<String>? = null,
    public val localStorageTypes: Output<List<String>>? = null,
    public val memoryGibPerVcpu:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null,
    public val memoryMib:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>? = null,
    public val networkBandwidthGbps:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null,
    public val networkInterfaceCount:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null,
    public val onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val requireHibernateSupport: Output<Boolean>? = null,
    public val spotMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val totalLocalStorageGb:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null,
    public val vcpuCount:
    Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder()
            .acceleratorCount(acceleratorCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .acceleratorManufacturers(
                acceleratorManufacturers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .acceleratorNames(acceleratorNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .acceleratorTotalMemoryMib(
                acceleratorTotalMemoryMib?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .acceleratorTypes(acceleratorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedInstanceTypes(allowedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bareMetal(bareMetal?.applyValue({ args0 -> args0 }))
            .baselineEbsBandwidthMbps(
                baselineEbsBandwidthMbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .burstablePerformance(burstablePerformance?.applyValue({ args0 -> args0 }))
            .cpuManufacturers(cpuManufacturers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedInstanceTypes(excludedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceGenerations(instanceGenerations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .localStorage(localStorage?.applyValue({ args0 -> args0 }))
            .localStorageTypes(localStorageTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memoryGibPerVcpu(memoryGibPerVcpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryMib(memoryMib?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkBandwidthGbps(
                networkBandwidthGbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkInterfaceCount(
                networkInterfaceCount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onDemandMaxPricePercentageOverLowestPrice(
                onDemandMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .requireHibernateSupport(requireHibernateSupport?.applyValue({ args0 -> args0 }))
            .spotMaxPricePercentageOverLowestPrice(
                spotMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .totalLocalStorageGb(
                totalLocalStorageGb?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vcpuCount(vcpuCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder internal
constructor() {
    private var acceleratorCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null

    private var acceleratorManufacturers: Output<List<String>>? = null

    private var acceleratorNames: Output<List<String>>? = null

    private var acceleratorTotalMemoryMib:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null

    private var acceleratorTypes: Output<List<String>>? = null

    private var allowedInstanceTypes: Output<List<String>>? = null

    private var bareMetal: Output<String>? = null

    private var baselineEbsBandwidthMbps:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null

    private var burstablePerformance: Output<String>? = null

    private var cpuManufacturers: Output<List<String>>? = null

    private var excludedInstanceTypes: Output<List<String>>? = null

    private var instanceGenerations: Output<List<String>>? = null

    private var localStorage: Output<String>? = null

    private var localStorageTypes: Output<List<String>>? = null

    private var memoryGibPerVcpu:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null

    private var memoryMib:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>? = null

    private var networkBandwidthGbps:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null

    private var networkInterfaceCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null

    private var onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var requireHibernateSupport: Output<Boolean>? = null

    private var spotMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var totalLocalStorageGb:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null

    private var vcpuCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>? = null

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("pkcixersalshjxaf")
    public suspend
    fun acceleratorCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>) {
        this.acceleratorCount = value
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("vtuvpjwcesjawyig")
    public suspend fun acceleratorManufacturers(`value`: Output<List<String>>) {
        this.acceleratorManufacturers = value
    }

    @JvmName("sgqvunsjsabscflc")
    public suspend fun acceleratorManufacturers(vararg values: Output<String>) {
        this.acceleratorManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("hmepqcuokukajgbw")
    public suspend fun acceleratorManufacturers(values: List<Output<String>>) {
        this.acceleratorManufacturers = Output.all(values)
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("xchyjmrhowiunnxt")
    public suspend fun acceleratorNames(`value`: Output<List<String>>) {
        this.acceleratorNames = value
    }

    @JvmName("umfepkuhdishmrar")
    public suspend fun acceleratorNames(vararg values: Output<String>) {
        this.acceleratorNames = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("nmhbkphromhxppbr")
    public suspend fun acceleratorNames(values: List<Output<String>>) {
        this.acceleratorNames = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("ejdrncgrfabtbwgx")
    public suspend
    fun acceleratorTotalMemoryMib(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>) {
        this.acceleratorTotalMemoryMib = value
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("klqonmjsfuxpnocm")
    public suspend fun acceleratorTypes(`value`: Output<List<String>>) {
        this.acceleratorTypes = value
    }

    @JvmName("pmwidmdpjptpejbx")
    public suspend fun acceleratorTypes(vararg values: Output<String>) {
        this.acceleratorTypes = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("njyxxyrutfypegou")
    public suspend fun acceleratorTypes(values: List<Output<String>>) {
        this.acceleratorTypes = Output.all(values)
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("wapbhiupioytbqgu")
    public suspend fun allowedInstanceTypes(`value`: Output<List<String>>) {
        this.allowedInstanceTypes = value
    }

    @JvmName("rqcxgtafktthmwov")
    public suspend fun allowedInstanceTypes(vararg values: Output<String>) {
        this.allowedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("lmemflmkhnolvhwd")
    public suspend fun allowedInstanceTypes(values: List<Output<String>>) {
        this.allowedInstanceTypes = Output.all(values)
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("whobnjetesegvilf")
    public suspend fun bareMetal(`value`: Output<String>) {
        this.bareMetal = value
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("hyowbdefdfjnicaq")
    public suspend
    fun baselineEbsBandwidthMbps(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>) {
        this.baselineEbsBandwidthMbps = value
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("swwffcfbbaylndtc")
    public suspend fun burstablePerformance(`value`: Output<String>) {
        this.burstablePerformance = value
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("hwjcuysahgqhxdxr")
    public suspend fun cpuManufacturers(`value`: Output<List<String>>) {
        this.cpuManufacturers = value
    }

    @JvmName("jysfxlfxqmivlhoq")
    public suspend fun cpuManufacturers(vararg values: Output<String>) {
        this.cpuManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("sgsxfagucenhnumt")
    public suspend fun cpuManufacturers(values: List<Output<String>>) {
        this.cpuManufacturers = Output.all(values)
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("dkseninsurvyagfy")
    public suspend fun excludedInstanceTypes(`value`: Output<List<String>>) {
        this.excludedInstanceTypes = value
    }

    @JvmName("bacmishvxrtbtwrl")
    public suspend fun excludedInstanceTypes(vararg values: Output<String>) {
        this.excludedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("iyrxbxftpljojqvf")
    public suspend fun excludedInstanceTypes(values: List<Output<String>>) {
        this.excludedInstanceTypes = Output.all(values)
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("cauoqbxvokovhcbb")
    public suspend fun instanceGenerations(`value`: Output<List<String>>) {
        this.instanceGenerations = value
    }

    @JvmName("bgaoffdoaqoopyii")
    public suspend fun instanceGenerations(vararg values: Output<String>) {
        this.instanceGenerations = Output.all(values.asList())
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("pvbqutiqiwkrxmhc")
    public suspend fun instanceGenerations(values: List<Output<String>>) {
        this.instanceGenerations = Output.all(values)
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("hbxwsnasrngbqpuy")
    public suspend fun localStorage(`value`: Output<String>) {
        this.localStorage = value
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("nbiiydushwfgobkn")
    public suspend fun localStorageTypes(`value`: Output<List<String>>) {
        this.localStorageTypes = value
    }

    @JvmName("xutauefrbjjlmxuv")
    public suspend fun localStorageTypes(vararg values: Output<String>) {
        this.localStorageTypes = Output.all(values.asList())
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("cxcxakxifsfovyix")
    public suspend fun localStorageTypes(values: List<Output<String>>) {
        this.localStorageTypes = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("ncmmjstjfremvavm")
    public suspend
    fun memoryGibPerVcpu(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>) {
        this.memoryGibPerVcpu = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("phdwwwluscmmffdv")
    public suspend
    fun memoryMib(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>) {
        this.memoryMib = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("xjjqkmrrfvxfmrdd")
    public suspend
    fun networkBandwidthGbps(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>) {
        this.networkBandwidthGbps = value
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("vwrpqrgaymerchtu")
    public suspend
    fun networkInterfaceCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>) {
        this.networkInterfaceCount = value
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("uehntdxfixytituf")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.onDemandMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("gonqxfiedanxetbw")
    public suspend fun requireHibernateSupport(`value`: Output<Boolean>) {
        this.requireHibernateSupport = value
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("ahofnkyrsrlxbiac")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.spotMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("srcjaucxcxpjdymq")
    public suspend
    fun totalLocalStorageGb(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>) {
        this.totalLocalStorageGb = value
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("lbpysqdubwlubrch")
    public suspend
    fun vcpuCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>) {
        this.vcpuCount = value
    }

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("lwviqgaoaflbghta")
    public suspend
    fun acceleratorCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("ehtwgwfphnngqirr")
    public suspend
    fun acceleratorCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorCount = mapped
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("saptlkmqucnfjkuj")
    public suspend fun acceleratorManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("ucnmgqijnlnwdhwo")
    public suspend fun acceleratorManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("bmsbstkxedaletvt")
    public suspend fun acceleratorNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("shsmwenoxsmdjyoc")
    public suspend fun acceleratorNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("xcaiohyypsfihvph")
    public suspend
    fun acceleratorTotalMemoryMib(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("soqeemadhiagfmvc")
    public suspend
    fun acceleratorTotalMemoryMib(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("jlimjjeojofnlimp")
    public suspend fun acceleratorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("xtulpohdwnwrpahe")
    public suspend fun acceleratorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("dsycdtdgqphuwlyw")
    public suspend fun allowedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("oddtnndpaikpolyy")
    public suspend fun allowedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("euxuwxtmmrlroioc")
    public suspend fun bareMetal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetal = mapped
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("hhfpmvxgkkynyhpl")
    public suspend
    fun baselineEbsBandwidthMbps(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("ufhstwijvnjfhlfj")
    public suspend
    fun baselineEbsBandwidthMbps(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("xqrvtjlostbiwgos")
    public suspend fun burstablePerformance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstablePerformance = mapped
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("rurbpqtypnbviwpo")
    public suspend fun cpuManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("tnfrkiwmqljynfbd")
    public suspend fun cpuManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("sofvvtaafxxetgix")
    public suspend fun excludedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("kbxdtrwmsmxecxth")
    public suspend fun excludedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("tknxrwpgqcmfucsk")
    public suspend fun instanceGenerations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("drwutjdcbfspeyoj")
    public suspend fun instanceGenerations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("rjcmlfhrincpqcrv")
    public suspend fun localStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorage = mapped
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("vgktmlfcgtcscocp")
    public suspend fun localStorageTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("kiamibgbgqstsbuc")
    public suspend fun localStorageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("bafdmnxmgbfhlwvl")
    public suspend
    fun memoryGibPerVcpu(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("wbdqqotgyhcthdtm")
    public suspend
    fun memoryGibPerVcpu(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("oreqjqqfpxthwunk")
    public suspend
    fun memoryMib(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("ptcilglrffyngkto")
    public suspend
    fun memoryMib(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryMib = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("eouubnabinnyxxnr")
    public suspend
    fun networkBandwidthGbps(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("npgruxifoxabrfan")
    public suspend
    fun networkBandwidthGbps(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("xyxwcdkcynllrmrv")
    public suspend
    fun networkInterfaceCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("xercrlheukbviqau")
    public suspend
    fun networkInterfaceCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaceCount = mapped
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("xujwrvpmygxoypob")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("evxarvwegqqgklam")
    public suspend fun requireHibernateSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireHibernateSupport = mapped
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("ugkrdmeugrsexixp")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("jcyafouqccpgfcpg")
    public suspend
    fun totalLocalStorageGb(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("xfhebxaeeuxemvft")
    public suspend
    fun totalLocalStorageGb(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("xxwaqdtwpmkxxxbm")
    public suspend
    fun vcpuCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcpuCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("qnoxdxfdminybkeg")
    public suspend
    fun vcpuCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vcpuCount = mapped
    }

    internal fun build(): SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs(
            acceleratorCount = acceleratorCount,
            acceleratorManufacturers = acceleratorManufacturers,
            acceleratorNames = acceleratorNames,
            acceleratorTotalMemoryMib = acceleratorTotalMemoryMib,
            acceleratorTypes = acceleratorTypes,
            allowedInstanceTypes = allowedInstanceTypes,
            bareMetal = bareMetal,
            baselineEbsBandwidthMbps = baselineEbsBandwidthMbps,
            burstablePerformance = burstablePerformance,
            cpuManufacturers = cpuManufacturers,
            excludedInstanceTypes = excludedInstanceTypes,
            instanceGenerations = instanceGenerations,
            localStorage = localStorage,
            localStorageTypes = localStorageTypes,
            memoryGibPerVcpu = memoryGibPerVcpu,
            memoryMib = memoryMib,
            networkBandwidthGbps = networkBandwidthGbps,
            networkInterfaceCount = networkInterfaceCount,
            onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice,
            requireHibernateSupport = requireHibernateSupport,
            spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice,
            totalLocalStorageGb = totalLocalStorageGb,
            vcpuCount = vcpuCount,
        )
}
