@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property capacityRebalance Nested argument containing the capacity rebalance for your fleet request. Defined below.
 */
public data class SpotFleetRequestSpotMaintenanceStrategiesArgs(
    public val capacityRebalance:
    Output<SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgs.builder()
            .capacityRebalance(
                capacityRebalance?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SpotFleetRequestSpotMaintenanceStrategiesArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestSpotMaintenanceStrategiesArgsBuilder internal constructor() {
    private var capacityRebalance:
        Output<SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs>? = null

    /**
     * @param value Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("fhpxbpxkevnelvtg")
    public suspend
    fun capacityRebalance(`value`: Output<SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs>) {
        this.capacityRebalance = value
    }

    /**
     * @param value Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("mbguhbfytnghceql")
    public suspend
    fun capacityRebalance(`value`: SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityRebalance = mapped
    }

    /**
     * @param argument Nested argument containing the capacity rebalance for your fleet request. Defined below.
     */
    @JvmName("yaxpkawnnhtetwas")
    public suspend
    fun capacityRebalance(argument: suspend SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityRebalance = mapped
    }

    internal fun build(): SpotFleetRequestSpotMaintenanceStrategiesArgs =
        SpotFleetRequestSpotMaintenanceStrategiesArgs(
            capacityRebalance = capacityRebalance,
        )
}
