@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestEnclaveOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether Nitro Enclaves will be enabled on the instance. Defaults to `false`.
 * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
 */
public data class SpotInstanceRequestEnclaveOptionsArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestEnclaveOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestEnclaveOptionsArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestEnclaveOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestEnclaveOptionsArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestEnclaveOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether Nitro Enclaves will be enabled on the instance. Defaults to `false`.
     * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
     */
    @JvmName("specgcqwvjybefgs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether Nitro Enclaves will be enabled on the instance. Defaults to `false`.
     * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
     */
    @JvmName("fihjelavfsuykphb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): SpotInstanceRequestEnclaveOptionsArgs =
        SpotInstanceRequestEnclaveOptionsArgs(
            enabled = enabled,
        )
}
