@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcEndpointDnsOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsRecordIpType The DNS records created for the endpoint. Valid values are `ipv4`, `dualstack`, `service-defined`, and `ipv6`.
 * @property privateDnsOnlyForInboundResolverEndpoint Indicates whether to enable private DNS only for inbound endpoints. This option is available only for services that support both gateway and interface endpoints. It routes traffic that originates from the VPC to the gateway endpoint and traffic that originates from on-premises to the interface endpoint. Default is `false`. Can only be specified if private_dns_enabled is `true`.
 */
public data class VpcEndpointDnsOptionsArgs(
    public val dnsRecordIpType: Output<String>? = null,
    public val privateDnsOnlyForInboundResolverEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcEndpointDnsOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcEndpointDnsOptionsArgs =
        com.pulumi.aws.ec2.inputs.VpcEndpointDnsOptionsArgs.builder()
            .dnsRecordIpType(dnsRecordIpType?.applyValue({ args0 -> args0 }))
            .privateDnsOnlyForInboundResolverEndpoint(
                privateDnsOnlyForInboundResolverEndpoint?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VpcEndpointDnsOptionsArgs].
 */
@PulumiTagMarker
public class VpcEndpointDnsOptionsArgsBuilder internal constructor() {
    private var dnsRecordIpType: Output<String>? = null

    private var privateDnsOnlyForInboundResolverEndpoint: Output<Boolean>? = null

    /**
     * @param value The DNS records created for the endpoint. Valid values are `ipv4`, `dualstack`, `service-defined`, and `ipv6`.
     */
    @JvmName("tosheohmkihaukxl")
    public suspend fun dnsRecordIpType(`value`: Output<String>) {
        this.dnsRecordIpType = value
    }

    /**
     * @param value Indicates whether to enable private DNS only for inbound endpoints. This option is available only for services that support both gateway and interface endpoints. It routes traffic that originates from the VPC to the gateway endpoint and traffic that originates from on-premises to the interface endpoint. Default is `false`. Can only be specified if private_dns_enabled is `true`.
     */
    @JvmName("uhcucnxmdtmgftvy")
    public suspend fun privateDnsOnlyForInboundResolverEndpoint(`value`: Output<Boolean>) {
        this.privateDnsOnlyForInboundResolverEndpoint = value
    }

    /**
     * @param value The DNS records created for the endpoint. Valid values are `ipv4`, `dualstack`, `service-defined`, and `ipv6`.
     */
    @JvmName("vdnycewqxvyxflrh")
    public suspend fun dnsRecordIpType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsRecordIpType = mapped
    }

    /**
     * @param value Indicates whether to enable private DNS only for inbound endpoints. This option is available only for services that support both gateway and interface endpoints. It routes traffic that originates from the VPC to the gateway endpoint and traffic that originates from on-premises to the interface endpoint. Default is `false`. Can only be specified if private_dns_enabled is `true`.
     */
    @JvmName("ayxjncpfnpihjayp")
    public suspend fun privateDnsOnlyForInboundResolverEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsOnlyForInboundResolverEndpoint = mapped
    }

    internal fun build(): VpcEndpointDnsOptionsArgs = VpcEndpointDnsOptionsArgs(
        dnsRecordIpType = dnsRecordIpType,
        privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint,
    )
}
