@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property message The plain-text authorization message for the prefix and account.
 * @property signature The signed authorization message for the prefix and account.
 */
public data class VpcIpamPoolCidrCidrAuthorizationContextArgs(
    public val message: Output<String>? = null,
    public val signature: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgs =
        com.pulumi.aws.ec2.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgs.builder()
            .message(message?.applyValue({ args0 -> args0 }))
            .signature(signature?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamPoolCidrCidrAuthorizationContextArgs].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrCidrAuthorizationContextArgsBuilder internal constructor() {
    private var message: Output<String>? = null

    private var signature: Output<String>? = null

    /**
     * @param value The plain-text authorization message for the prefix and account.
     */
    @JvmName("kkvbaqkraugcoxde")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The signed authorization message for the prefix and account.
     */
    @JvmName("tdeuljuslikryevf")
    public suspend fun signature(`value`: Output<String>) {
        this.signature = value
    }

    /**
     * @param value The plain-text authorization message for the prefix and account.
     */
    @JvmName("ajkailrojxegubxf")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The signed authorization message for the prefix and account.
     */
    @JvmName("vlrwaphlyweibxyc")
    public suspend fun signature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signature = mapped
    }

    internal fun build(): VpcIpamPoolCidrCidrAuthorizationContextArgs =
        VpcIpamPoolCidrCidrAuthorizationContextArgs(
            message = message,
            signature = signature,
        )
}
