@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionName The name of the Region you want to add to the IPAM.
 */
public data class VpcIpamResourceDiscoveryOperatingRegionArgs(
    public val regionName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs =
        com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs.builder()
            .regionName(regionName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamResourceDiscoveryOperatingRegionArgs].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryOperatingRegionArgsBuilder internal constructor() {
    private var regionName: Output<String>? = null

    /**
     * @param value The name of the Region you want to add to the IPAM.
     */
    @JvmName("myctebdmxaulivpj")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value The name of the Region you want to add to the IPAM.
     */
    @JvmName("moymcdwcqfusiqdq")
    public suspend fun regionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    internal fun build(): VpcIpamResourceDiscoveryOperatingRegionArgs =
        VpcIpamResourceDiscoveryOperatingRegionArgs(
            regionName = regionName ?: throw PulumiNullFieldException("regionName"),
        )
}
