@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcPeeringConnectionAccepterAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowRemoteVpcDnsResolution Indicates whether a local VPC can resolve public DNS hostnames to
 * private IP addresses when queried from instances in a peer VPC.
 */
public data class VpcPeeringConnectionAccepterAccepterArgs(
    public val allowRemoteVpcDnsResolution: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcPeeringConnectionAccepterAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcPeeringConnectionAccepterAccepterArgs =
        com.pulumi.aws.ec2.inputs.VpcPeeringConnectionAccepterAccepterArgs.builder()
            .allowRemoteVpcDnsResolution(allowRemoteVpcDnsResolution?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcPeeringConnectionAccepterAccepterArgs].
 */
@PulumiTagMarker
public class VpcPeeringConnectionAccepterAccepterArgsBuilder internal constructor() {
    private var allowRemoteVpcDnsResolution: Output<Boolean>? = null

    /**
     * @param value Indicates whether a local VPC can resolve public DNS hostnames to
     * private IP addresses when queried from instances in a peer VPC.
     */
    @JvmName("ufskodbnivssrktl")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Output<Boolean>) {
        this.allowRemoteVpcDnsResolution = value
    }

    /**
     * @param value Indicates whether a local VPC can resolve public DNS hostnames to
     * private IP addresses when queried from instances in a peer VPC.
     */
    @JvmName("huuqtquxipasddan")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVpcDnsResolution = mapped
    }

    internal fun build(): VpcPeeringConnectionAccepterAccepterArgs =
        VpcPeeringConnectionAccepterAccepterArgs(
            allowRemoteVpcDnsResolution = allowRemoteVpcDnsResolution,
        )
}
