@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The CIDR block of the route.
 * @property coreNetworkArn The Amazon Resource Name (ARN) of a core network.
 * @property destinationPrefixListId The ID of a managed prefix list destination of the route.
 * One of the following target arguments must be supplied:
 * @property egressOnlyGatewayId Identifier of a VPC Egress Only Internet Gateway.
 * @property gatewayId Identifier of a VPC internet gateway or a virtual private gateway.
 * @property instanceId Identifier of an EC2 instance.
 * @property ipv6CidrBlock The Ipv6 CIDR block of the route
 * @property natGatewayId Identifier of a VPC NAT gateway.
 * @property networkInterfaceId Identifier of an EC2 network interface.
 * @property transitGatewayId Identifier of an EC2 Transit Gateway.
 * @property vpcEndpointId Identifier of a VPC Endpoint. This route must be removed prior to VPC Endpoint deletion.
 * @property vpcPeeringConnectionId Identifier of a VPC peering connection.
 * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
 */
public data class DefaultRouteTableRoute(
    public val cidrBlock: String? = null,
    public val coreNetworkArn: String? = null,
    public val destinationPrefixListId: String? = null,
    public val egressOnlyGatewayId: String? = null,
    public val gatewayId: String? = null,
    public val instanceId: String? = null,
    public val ipv6CidrBlock: String? = null,
    public val natGatewayId: String? = null,
    public val networkInterfaceId: String? = null,
    public val transitGatewayId: String? = null,
    public val vpcEndpointId: String? = null,
    public val vpcPeeringConnectionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.DefaultRouteTableRoute):
            DefaultRouteTableRoute = DefaultRouteTableRoute(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            coreNetworkArn = javaType.coreNetworkArn().map({ args0 -> args0 }).orElse(null),
            destinationPrefixListId = javaType.destinationPrefixListId().map({ args0 -> args0 }).orElse(null),
            egressOnlyGatewayId = javaType.egressOnlyGatewayId().map({ args0 -> args0 }).orElse(null),
            gatewayId = javaType.gatewayId().map({ args0 -> args0 }).orElse(null),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            ipv6CidrBlock = javaType.ipv6CidrBlock().map({ args0 -> args0 }).orElse(null),
            natGatewayId = javaType.natGatewayId().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            transitGatewayId = javaType.transitGatewayId().map({ args0 -> args0 }).orElse(null),
            vpcEndpointId = javaType.vpcEndpointId().map({ args0 -> args0 }).orElse(null),
            vpcPeeringConnectionId = javaType.vpcPeeringConnectionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
