@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceIds The IDs of the instances.
 * @property instanceType Instance type.
 * @property lifecycle Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
 * @property platform The value is `Windows` for Windows instances. Otherwise, the value is blank.
 */
public data class FleetFleetInstanceSet(
    public val instanceIds: List<String>? = null,
    public val instanceType: String? = null,
    public val lifecycle: String? = null,
    public val platform: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetFleetInstanceSet):
            FleetFleetInstanceSet = FleetFleetInstanceSet(
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            lifecycle = javaType.lifecycle().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().map({ args0 -> args0 }).orElse(null),
        )
    }
}
