@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone Availability Zone in which to launch the instances.
 * @property instanceRequirements Override the instance type in the Launch Template with instance types that satisfy the requirements.
 * @property instanceType Instance type.
 * @property maxPrice Maximum price per unit hour that you are willing to pay for a Spot Instance.
 * @property priority Priority for the launch template override. If `on_demand_options` `allocation_strategy` is set to `prioritized`, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. Valid values are whole numbers starting at 0.
 * @property subnetId ID of the subnet in which to launch the instances.
 * @property weightedCapacity Number of units provided by the specified instance type.
 */
public data class FleetLaunchTemplateConfigOverride(
    public val availabilityZone: String? = null,
    public val instanceRequirements: FleetLaunchTemplateConfigOverrideInstanceRequirements? = null,
    public val instanceType: String? = null,
    public val maxPrice: String? = null,
    public val priority: Double? = null,
    public val subnetId: String? = null,
    public val weightedCapacity: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetLaunchTemplateConfigOverride):
            FleetLaunchTemplateConfigOverride = FleetLaunchTemplateConfigOverride(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            instanceRequirements = javaType.instanceRequirements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.FleetLaunchTemplateConfigOverrideInstanceRequirements.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            maxPrice = javaType.maxPrice().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
