@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStrategy The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
 * @property maxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
 * @property minTargetCapacity The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
 * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
 * @property singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
 * @property singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
 */
public data class FleetOnDemandOptions(
    public val allocationStrategy: String? = null,
    public val maxTotalPrice: String? = null,
    public val minTargetCapacity: Int? = null,
    public val singleAvailabilityZone: Boolean? = null,
    public val singleInstanceType: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetOnDemandOptions):
            FleetOnDemandOptions = FleetOnDemandOptions(
            allocationStrategy = javaType.allocationStrategy().map({ args0 -> args0 }).orElse(null),
            maxTotalPrice = javaType.maxTotalPrice().map({ args0 -> args0 }).orElse(null),
            minTargetCapacity = javaType.minTargetCapacity().map({ args0 -> args0 }).orElse(null),
            singleAvailabilityZone = javaType.singleAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            singleInstanceType = javaType.singleInstanceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
