@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property deviceName Physical name of the device.
 * @property ebs Map containing EBS information, if the device is EBS based. Unlike most object attributes, these are accessed directly (e.g., `ebs.volume_size` or `ebs["volume_size"]`) rather than accessed through the first element of a list (e&#46;g&#46;, `ebs[0].volume_size`).
 * @property noDevice Suppresses the specified device included in the block device mapping of the AMI.
 * @property virtualName Virtual device name (for instance stores).
 */
public data class GetAmiBlockDeviceMapping(
    public val deviceName: String,
    public val ebs: Map<String, String>,
    public val noDevice: String,
    public val virtualName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetAmiBlockDeviceMapping):
            GetAmiBlockDeviceMapping = GetAmiBlockDeviceMapping(
            deviceName = javaType.deviceName(),
            ebs = javaType.ebs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            noDevice = javaType.noDevice(),
            virtualName = javaType.virtualName(),
        )
    }
}
