@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCustomerGateway.
 * @property arn ARN of the customer gateway.
 * @property bgpAsn Gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
 * @property certificateArn ARN for the customer gateway certificate.
 * @property deviceName Name for the customer gateway device.
 * @property filters
 * @property id
 * @property ipAddress IP address of the gateway's Internet-routable external interface.
 * @property tags Map of key-value pairs assigned to the gateway.
 * @property type Type of customer gateway. The only type AWS supports at this time is "ipsec.1".
 */
public data class GetCustomerGatewayResult(
    public val arn: String,
    public val bgpAsn: Int,
    public val certificateArn: String,
    public val deviceName: String,
    public val filters: List<GetCustomerGatewayFilter>? = null,
    public val id: String,
    public val ipAddress: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetCustomerGatewayResult):
            GetCustomerGatewayResult = GetCustomerGatewayResult(
            arn = javaType.arn(),
            bgpAsn = javaType.bgpAsn(),
            certificateArn = javaType.certificateArn(),
            deviceName = javaType.deviceName(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetCustomerGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
