@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEips.
 * @property allocationIds List of all the allocation IDs for address for use with EC2-VPC.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property publicIps List of all the Elastic IP addresses.
 * @property tags
 */
public data class GetEipsResult(
    public val allocationIds: List<String>,
    public val filters: List<GetEipsFilter>? = null,
    public val id: String,
    public val publicIps: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetEipsResult): GetEipsResult =
            GetEipsResult(
                allocationIds = javaType.allocationIds().map({ args0 -> args0 }),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetEipsFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                publicIps = javaType.publicIps().map({ args0 -> args0 }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
