@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getElasticIp.
 * @property associationId ID representing the association of the address with an instance in a VPC.
 * @property carrierIp Carrier IP address.
 * @property customerOwnedIp Customer Owned IP.
 * @property customerOwnedIpv4Pool The ID of a Customer Owned IP Pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing)
 * @property domain Whether the address is for use in EC2-Classic (standard) or in a VPC (vpc).
 * @property filters
 * @property id If VPC Elastic IP, the allocation identifier. If EC2-Classic Elastic IP, the public IP address.
 * @property instanceId ID of the instance that the address is associated with (if any).
 * @property networkInterfaceId The ID of the network interface.
 * @property networkInterfaceOwnerId The ID of the AWS account that owns the network interface.
 * @property privateDns Private DNS associated with the Elastic IP address.
 * @property privateIp Private IP address associated with the Elastic IP address.
 * @property publicDns Public DNS associated with the Elastic IP address.
 * @property publicIp Public IP address of Elastic IP.
 * @property publicIpv4Pool ID of an address pool.
 * @property tags Key-value map of tags associated with Elastic IP.
 */
public data class GetElasticIpResult(
    public val associationId: String,
    public val carrierIp: String,
    public val customerOwnedIp: String,
    public val customerOwnedIpv4Pool: String,
    public val domain: String,
    public val filters: List<GetElasticIpFilter>? = null,
    public val id: String,
    public val instanceId: String,
    public val networkInterfaceId: String,
    public val networkInterfaceOwnerId: String,
    public val privateDns: String,
    public val privateIp: String,
    public val publicDns: String,
    public val publicIp: String,
    public val publicIpv4Pool: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetElasticIpResult): GetElasticIpResult =
            GetElasticIpResult(
                associationId = javaType.associationId(),
                carrierIp = javaType.carrierIp(),
                customerOwnedIp = javaType.customerOwnedIp(),
                customerOwnedIpv4Pool = javaType.customerOwnedIpv4Pool(),
                domain = javaType.domain(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetElasticIpFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                networkInterfaceId = javaType.networkInterfaceId(),
                networkInterfaceOwnerId = javaType.networkInterfaceOwnerId(),
                privateDns = javaType.privateDns(),
                privateIp = javaType.privateIp(),
                publicDns = javaType.publicDns(),
                publicIp = javaType.publicIp(),
                publicIpv4Pool = javaType.publicIpv4Pool(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
