@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Physical name of the device.
 * @property noDevice Whether the specified device included in the device mapping was suppressed or not (Boolean).
 * @property virtualName Virtual device name.
 */
public data class GetInstanceEphemeralBlockDevice(
    public val deviceName: String,
    public val noDevice: Boolean? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceEphemeralBlockDevice):
            GetInstanceEphemeralBlockDevice = GetInstanceEphemeralBlockDevice(
            deviceName = javaType.deviceName(),
            noDevice = javaType.noDevice().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
