@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpEndpoint State of the metadata service: `enabled`, `disabled`.
 * @property httpProtocolIpv6 Whether the IPv6 endpoint for the instance metadata service is `enabled` or `disabled`
 * @property httpPutResponseHopLimit Desired HTTP PUT response hop limit for instance metadata requests.
 * @property httpTokens If session tokens are required: `optional`, `required`.
 * @property instanceMetadataTags If access to instance tags is allowed from the metadata service: `enabled`, `disabled`.
 */
public data class GetInstanceMetadataOption(
    public val httpEndpoint: String,
    public val httpProtocolIpv6: String,
    public val httpPutResponseHopLimit: Int,
    public val httpTokens: String,
    public val instanceMetadataTags: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceMetadataOption):
            GetInstanceMetadataOption = GetInstanceMetadataOption(
            httpEndpoint = javaType.httpEndpoint(),
            httpProtocolIpv6 = javaType.httpProtocolIpv6(),
            httpPutResponseHopLimit = javaType.httpPutResponseHopLimit(),
            httpTokens = javaType.httpTokens(),
            instanceMetadataTags = javaType.instanceMetadataTags(),
        )
    }
}
