@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
 * @property enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
 * @property hostnameType Type of hostname for EC2 instances.
 */
public data class GetInstancePrivateDnsNameOption(
    public val enableResourceNameDnsARecord: Boolean,
    public val enableResourceNameDnsAaaaRecord: Boolean,
    public val hostnameType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstancePrivateDnsNameOption):
            GetInstancePrivateDnsNameOption = GetInstancePrivateDnsNameOption(
            enableResourceNameDnsARecord = javaType.enableResourceNameDnsARecord(),
            enableResourceNameDnsAaaaRecord = javaType.enableResourceNameDnsAaaaRecord(),
            hostnameType = javaType.hostnameType(),
        )
    }
}
