@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count
 * @property manufacturer
 * @property memorySize Size of the instance memory, in MiB.
 * @property name
 */
public data class GetInstanceTypeGpus(
    public val count: Int,
    public val manufacturer: String,
    public val memorySize: Int,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypeGpus):
            GetInstanceTypeGpus = GetInstanceTypeGpus(
            count = javaType.count(),
            manufacturer = javaType.manufacturer(),
            memorySize = javaType.memorySize(),
            name = javaType.name(),
        )
    }
}
