@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypeOfferings.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceTypes List of EC2 Instance Types.
 * @property locationType
 * @property locationTypes List of location types.
 * @property locations List of locations.
 */
public data class GetInstanceTypeOfferingsResult(
    public val filters: List<GetInstanceTypeOfferingsFilter>? = null,
    public val id: String,
    public val instanceTypes: List<String>,
    public val locationType: String? = null,
    public val locationTypes: List<String>,
    public val locations: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypeOfferingsResult):
            GetInstanceTypeOfferingsResult = GetInstanceTypeOfferingsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
            locationType = javaType.locationType().map({ args0 -> args0 }).orElse(null),
            locationTypes = javaType.locationTypes().map({ args0 -> args0 }),
            locations = javaType.locations().map({ args0 -> args0 }),
        )
    }
}
