@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceType.
 * @property autoRecoverySupported `true` if auto recovery is supported.
 * @property bareMetal `true` if it is a bare metal instance type.
 * @property burstablePerformanceSupported `true` if the instance type is a burstable performance instance type.
 * @property currentGeneration `true`  if the instance type is a current generation.
 * @property dedicatedHostsSupported `true` if Dedicated Hosts are supported on the instance type.
 * @property defaultCores Default number of cores for the instance type.
 * @property defaultThreadsPerCore The  default  number of threads per core for the instance type.
 * @property defaultVcpus Default number of vCPUs for the instance type.
 * @property ebsEncryptionSupport Indicates whether Amazon EBS encryption is supported.
 * @property ebsNvmeSupport Whether non-volatile memory express (NVMe) is supported.
 * @property ebsOptimizedSupport Indicates that the instance type is Amazon EBS-optimized.
 * @property ebsPerformanceBaselineBandwidth The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
 * @property ebsPerformanceBaselineIops The baseline input/output storage operations per seconds for an EBS-optimized instance type.
 * @property ebsPerformanceBaselineThroughput The baseline throughput performance for an EBS-optimized instance type, in MBps.
 * @property ebsPerformanceMaximumBandwidth The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
 * @property ebsPerformanceMaximumIops The maximum input/output storage operations per second for an EBS-optimized instance type.
 * @property ebsPerformanceMaximumThroughput The maximum throughput performance for an EBS-optimized instance type, in MBps.
 * @property efaSupported Whether Elastic Fabric Adapter (EFA) is supported.
 * @property enaSupport Whether Elastic Network Adapter (ENA) is supported.
 * @property encryptionInTransitSupported Indicates whether encryption in-transit between instances is supported.
 * @property fpgas Describes the FPGA accelerator settings for the instance type.
 * * `fpgas.#.count` - The count of FPGA accelerators for the instance type.
 * * `fpgas.#.manufacturer` - The manufacturer of the FPGA accelerator.
 * * `fpgas.#.memory_size` - The size (in MiB) for the memory available to the FPGA accelerator.
 * * `fpgas.#.name` - The name of the FPGA accelerator.
 * @property freeTierEligible `true` if the instance type is eligible for the free tier.
 * @property gpuses Describes the GPU accelerators for the instance type.
 * * `gpus.#.count` - The number of GPUs for the instance type.
 * * `gpus.#.manufacturer` - The manufacturer of the GPU accelerator.
 * * `gpus.#.memory_size` - The size (in MiB) for the memory available to the GPU accelerator.
 * * `gpus.#.name` - The name of the GPU accelerator.
 * @property hibernationSupported `true` if On-Demand hibernation is supported.
 * @property hypervisor Hypervisor used for the instance type.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property inferenceAccelerators Describes the Inference accelerators for the instance type.
 * * `inference_accelerators.#.count` - The number of Inference accelerators for the instance type.
 * * `inference_accelerators.#.manufacturer` - The manufacturer of the Inference accelerator.
 * * `inference_accelerators.#.name` - The name of the Inference accelerator.
 * @property instanceDisks Describes the disks for the instance type.
 * * `instance_disks.#.count` - The number of disks with this configuration.
 * * `instance_disks.#.size` - The size of the disk in GB.
 * * `instance_disks.#.type` - The type of disk.
 * @property instanceStorageSupported `true` if instance storage is supported.
 * @property instanceType
 * @property ipv6Supported `true` if IPv6 is supported.
 * @property maximumIpv4AddressesPerInterface The maximum number of IPv4 addresses per network interface.
 * @property maximumIpv6AddressesPerInterface The maximum number of IPv6 addresses per network interface.
 * @property maximumNetworkInterfaces The maximum number of network interfaces for the instance type.
 * @property memorySize Size of the instance memory, in MiB.
 * @property networkPerformance Describes the network performance.
 * @property supportedArchitectures A list of architectures supported by the instance type.
 * @property supportedPlacementStrategies A list of supported placement groups types.
 * @property supportedRootDeviceTypes Indicates the supported root device types.
 * @property supportedUsagesClasses Indicates whether the instance type is offered for spot or On-Demand.
 * @property supportedVirtualizationTypes The supported virtualization types.
 * @property sustainedClockSpeed The speed of the processor, in GHz.
 * @property totalFpgaMemory Total memory of all FPGA accelerators for the instance type (in MiB).
 * @property totalGpuMemory Total size of the memory for the GPU accelerators for the instance type (in MiB).
 * @property totalInstanceStorage The total size of the instance disks, in GB.
 * @property validCores List of the valid number of cores that can be configured for the instance type.
 * @property validThreadsPerCores List of the valid number of threads per core that can be configured for the instance type.
 */
public data class GetInstanceTypeResult(
    public val autoRecoverySupported: Boolean,
    public val bareMetal: Boolean,
    public val burstablePerformanceSupported: Boolean,
    public val currentGeneration: Boolean,
    public val dedicatedHostsSupported: Boolean,
    public val defaultCores: Int,
    public val defaultThreadsPerCore: Int,
    public val defaultVcpus: Int,
    public val ebsEncryptionSupport: String,
    public val ebsNvmeSupport: String,
    public val ebsOptimizedSupport: String,
    public val ebsPerformanceBaselineBandwidth: Int,
    public val ebsPerformanceBaselineIops: Int,
    public val ebsPerformanceBaselineThroughput: Double,
    public val ebsPerformanceMaximumBandwidth: Int,
    public val ebsPerformanceMaximumIops: Int,
    public val ebsPerformanceMaximumThroughput: Double,
    public val efaSupported: Boolean,
    public val enaSupport: String,
    public val encryptionInTransitSupported: Boolean,
    public val fpgas: List<GetInstanceTypeFpga>,
    public val freeTierEligible: Boolean,
    public val gpuses: List<GetInstanceTypeGpus>,
    public val hibernationSupported: Boolean,
    public val hypervisor: String,
    public val id: String,
    public val inferenceAccelerators: List<GetInstanceTypeInferenceAccelerator>,
    public val instanceDisks: List<GetInstanceTypeInstanceDisk>,
    public val instanceStorageSupported: Boolean,
    public val instanceType: String,
    public val ipv6Supported: Boolean,
    public val maximumIpv4AddressesPerInterface: Int,
    public val maximumIpv6AddressesPerInterface: Int,
    public val maximumNetworkInterfaces: Int,
    public val memorySize: Int,
    public val networkPerformance: String,
    public val supportedArchitectures: List<String>,
    public val supportedPlacementStrategies: List<String>,
    public val supportedRootDeviceTypes: List<String>,
    public val supportedUsagesClasses: List<String>,
    public val supportedVirtualizationTypes: List<String>,
    public val sustainedClockSpeed: Double,
    public val totalFpgaMemory: Int,
    public val totalGpuMemory: Int,
    public val totalInstanceStorage: Int,
    public val validCores: List<Int>,
    public val validThreadsPerCores: List<Int>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypeResult):
            GetInstanceTypeResult = GetInstanceTypeResult(
            autoRecoverySupported = javaType.autoRecoverySupported(),
            bareMetal = javaType.bareMetal(),
            burstablePerformanceSupported = javaType.burstablePerformanceSupported(),
            currentGeneration = javaType.currentGeneration(),
            dedicatedHostsSupported = javaType.dedicatedHostsSupported(),
            defaultCores = javaType.defaultCores(),
            defaultThreadsPerCore = javaType.defaultThreadsPerCore(),
            defaultVcpus = javaType.defaultVcpus(),
            ebsEncryptionSupport = javaType.ebsEncryptionSupport(),
            ebsNvmeSupport = javaType.ebsNvmeSupport(),
            ebsOptimizedSupport = javaType.ebsOptimizedSupport(),
            ebsPerformanceBaselineBandwidth = javaType.ebsPerformanceBaselineBandwidth(),
            ebsPerformanceBaselineIops = javaType.ebsPerformanceBaselineIops(),
            ebsPerformanceBaselineThroughput = javaType.ebsPerformanceBaselineThroughput(),
            ebsPerformanceMaximumBandwidth = javaType.ebsPerformanceMaximumBandwidth(),
            ebsPerformanceMaximumIops = javaType.ebsPerformanceMaximumIops(),
            ebsPerformanceMaximumThroughput = javaType.ebsPerformanceMaximumThroughput(),
            efaSupported = javaType.efaSupported(),
            enaSupport = javaType.enaSupport(),
            encryptionInTransitSupported = javaType.encryptionInTransitSupported(),
            fpgas = javaType.fpgas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeFpga.Companion.toKotlin(args0)
                })
            }),
            freeTierEligible = javaType.freeTierEligible(),
            gpuses = javaType.gpuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeGpus.Companion.toKotlin(args0)
                })
            }),
            hibernationSupported = javaType.hibernationSupported(),
            hypervisor = javaType.hypervisor(),
            id = javaType.id(),
            inferenceAccelerators = javaType.inferenceAccelerators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeInferenceAccelerator.Companion.toKotlin(args0)
                })
            }),
            instanceDisks = javaType.instanceDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeInstanceDisk.Companion.toKotlin(args0)
                })
            }),
            instanceStorageSupported = javaType.instanceStorageSupported(),
            instanceType = javaType.instanceType(),
            ipv6Supported = javaType.ipv6Supported(),
            maximumIpv4AddressesPerInterface = javaType.maximumIpv4AddressesPerInterface(),
            maximumIpv6AddressesPerInterface = javaType.maximumIpv6AddressesPerInterface(),
            maximumNetworkInterfaces = javaType.maximumNetworkInterfaces(),
            memorySize = javaType.memorySize(),
            networkPerformance = javaType.networkPerformance(),
            supportedArchitectures = javaType.supportedArchitectures().map({ args0 -> args0 }),
            supportedPlacementStrategies = javaType.supportedPlacementStrategies().map({ args0 -> args0 }),
            supportedRootDeviceTypes = javaType.supportedRootDeviceTypes().map({ args0 -> args0 }),
            supportedUsagesClasses = javaType.supportedUsagesClasses().map({ args0 -> args0 }),
            supportedVirtualizationTypes = javaType.supportedVirtualizationTypes().map({ args0 -> args0 }),
            sustainedClockSpeed = javaType.sustainedClockSpeed(),
            totalFpgaMemory = javaType.totalFpgaMemory(),
            totalGpuMemory = javaType.totalGpuMemory(),
            totalInstanceStorage = javaType.totalInstanceStorage(),
            validCores = javaType.validCores().map({ args0 -> args0 }),
            validThreadsPerCores = javaType.validThreadsPerCores().map({ args0 -> args0 }),
        )
    }
}
