@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypes.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceTypes List of EC2 Instance Types.
 */
public data class GetInstanceTypesResult(
    public val filters: List<GetInstanceTypesFilter>? = null,
    public val id: String,
    public val instanceTypes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInstanceTypesResult):
            GetInstanceTypesResult = GetInstanceTypesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
        )
    }
}
