@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property state Current state of the attachment between the gateway and the VPC. Present only if a VPC is attached
 * @property vpcId ID of an attached VPC.
 */
public data class GetInternetGatewayAttachment(
    public val state: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetInternetGatewayAttachment):
            GetInternetGatewayAttachment = GetInternetGatewayAttachment(
            state = javaType.state(),
            vpcId = javaType.vpcId(),
        )
    }
}
