@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property marketType
 * @property spotOptions
 */
public data class GetLaunchTemplateInstanceMarketOption(
    public val marketType: String,
    public val spotOptions: List<GetLaunchTemplateInstanceMarketOptionSpotOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateInstanceMarketOption):
            GetLaunchTemplateInstanceMarketOption = GetLaunchTemplateInstanceMarketOption(
            marketType = javaType.marketType(),
            spotOptions = javaType.spotOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceMarketOptionSpotOption.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
