@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLaunchTemplate.
 * @property arn
 * @property blockDeviceMappings
 * @property capacityReservationSpecifications
 * @property cpuOptions
 * @property creditSpecifications
 * @property defaultVersion
 * @property description
 * @property disableApiStop
 * @property disableApiTermination
 * @property ebsOptimized
 * @property elasticGpuSpecifications
 * @property elasticInferenceAccelerators
 * @property enclaveOptions
 * @property filters
 * @property hibernationOptions
 * @property iamInstanceProfiles
 * @property id ID of the launch template.
 * @property imageId
 * @property instanceInitiatedShutdownBehavior
 * @property instanceMarketOptions
 * @property instanceRequirements
 * @property instanceType
 * @property kernelId
 * @property keyName
 * @property latestVersion
 * @property licenseSpecifications
 * @property maintenanceOptions
 * @property metadataOptions
 * @property monitorings
 * @property name
 * @property networkInterfaces
 * @property placements
 * @property privateDnsNameOptions
 * @property ramDiskId
 * @property securityGroupNames
 * @property tagSpecifications
 * @property tags
 * @property userData
 * @property vpcSecurityGroupIds
 */
public data class GetLaunchTemplateResult(
    public val arn: String,
    public val blockDeviceMappings: List<GetLaunchTemplateBlockDeviceMapping>,
    public val capacityReservationSpecifications:
    List<GetLaunchTemplateCapacityReservationSpecification>,
    public val cpuOptions: List<GetLaunchTemplateCpuOption>,
    public val creditSpecifications: List<GetLaunchTemplateCreditSpecification>,
    public val defaultVersion: Int,
    public val description: String,
    public val disableApiStop: Boolean,
    public val disableApiTermination: Boolean,
    public val ebsOptimized: String,
    public val elasticGpuSpecifications: List<GetLaunchTemplateElasticGpuSpecification>,
    public val elasticInferenceAccelerators: List<GetLaunchTemplateElasticInferenceAccelerator>,
    public val enclaveOptions: List<GetLaunchTemplateEnclaveOption>,
    public val filters: List<GetLaunchTemplateFilter>? = null,
    public val hibernationOptions: List<GetLaunchTemplateHibernationOption>,
    public val iamInstanceProfiles: List<GetLaunchTemplateIamInstanceProfile>,
    public val id: String,
    public val imageId: String,
    public val instanceInitiatedShutdownBehavior: String,
    public val instanceMarketOptions: List<GetLaunchTemplateInstanceMarketOption>,
    public val instanceRequirements: List<GetLaunchTemplateInstanceRequirement>,
    public val instanceType: String,
    public val kernelId: String,
    public val keyName: String,
    public val latestVersion: Int,
    public val licenseSpecifications: List<GetLaunchTemplateLicenseSpecification>,
    public val maintenanceOptions: List<GetLaunchTemplateMaintenanceOption>,
    public val metadataOptions: List<GetLaunchTemplateMetadataOption>,
    public val monitorings: List<GetLaunchTemplateMonitoring>,
    public val name: String,
    public val networkInterfaces: List<GetLaunchTemplateNetworkInterface>,
    public val placements: List<GetLaunchTemplatePlacement>,
    public val privateDnsNameOptions: List<GetLaunchTemplatePrivateDnsNameOption>,
    public val ramDiskId: String,
    public val securityGroupNames: List<String>,
    public val tagSpecifications: List<GetLaunchTemplateTagSpecification>,
    public val tags: Map<String, String>,
    public val userData: String,
    public val vpcSecurityGroupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateResult):
            GetLaunchTemplateResult = GetLaunchTemplateResult(
            arn = javaType.arn(),
            blockDeviceMappings = javaType.blockDeviceMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateBlockDeviceMapping.Companion.toKotlin(args0)
                })
            }),
            capacityReservationSpecifications = javaType.capacityReservationSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateCapacityReservationSpecification.Companion.toKotlin(args0)
                })
            }),
            cpuOptions = javaType.cpuOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateCpuOption.Companion.toKotlin(args0)
                })
            }),
            creditSpecifications = javaType.creditSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateCreditSpecification.Companion.toKotlin(args0)
                })
            }),
            defaultVersion = javaType.defaultVersion(),
            description = javaType.description(),
            disableApiStop = javaType.disableApiStop(),
            disableApiTermination = javaType.disableApiTermination(),
            ebsOptimized = javaType.ebsOptimized(),
            elasticGpuSpecifications = javaType.elasticGpuSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateElasticGpuSpecification.Companion.toKotlin(args0)
                })
            }),
            elasticInferenceAccelerators = javaType.elasticInferenceAccelerators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateElasticInferenceAccelerator.Companion.toKotlin(args0)
                })
            }),
            enclaveOptions = javaType.enclaveOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateEnclaveOption.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateFilter.Companion.toKotlin(args0)
                })
            }),
            hibernationOptions = javaType.hibernationOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateHibernationOption.Companion.toKotlin(args0)
                })
            }),
            iamInstanceProfiles = javaType.iamInstanceProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateIamInstanceProfile.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceInitiatedShutdownBehavior = javaType.instanceInitiatedShutdownBehavior(),
            instanceMarketOptions = javaType.instanceMarketOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceMarketOption.Companion.toKotlin(args0)
                })
            }),
            instanceRequirements = javaType.instanceRequirements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateInstanceRequirement.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            kernelId = javaType.kernelId(),
            keyName = javaType.keyName(),
            latestVersion = javaType.latestVersion(),
            licenseSpecifications = javaType.licenseSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateLicenseSpecification.Companion.toKotlin(args0)
                })
            }),
            maintenanceOptions = javaType.maintenanceOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateMaintenanceOption.Companion.toKotlin(args0)
                })
            }),
            metadataOptions = javaType.metadataOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateMetadataOption.Companion.toKotlin(args0)
                })
            }),
            monitorings = javaType.monitorings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateMonitoring.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            placements = javaType.placements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplatePlacement.Companion.toKotlin(args0)
                })
            }),
            privateDnsNameOptions = javaType.privateDnsNameOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplatePrivateDnsNameOption.Companion.toKotlin(args0)
                })
            }),
            ramDiskId = javaType.ramDiskId(),
            securityGroupNames = javaType.securityGroupNames().map({ args0 -> args0 }),
            tagSpecifications = javaType.tagSpecifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateTagSpecification.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userData = javaType.userData(),
            vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
