@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property resourceType
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
 */
public data class GetLaunchTemplateTagSpecification(
    public val resourceType: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLaunchTemplateTagSpecification):
            GetLaunchTemplateTagSpecification = GetLaunchTemplateTagSpecification(
            resourceType = javaType.resourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
