@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
 * @property filters
 * @property id
 * @property localGatewayId
 * @property localGatewayVirtualInterfaceIds Set of EC2 Local Gateway Virtual Interface identifiers.
 * @property tags
 */
public data class GetLocalGatewayVirtualInterfaceGroupResult(
    public val filters: List<GetLocalGatewayVirtualInterfaceGroupFilter>? = null,
    public val id: String,
    public val localGatewayId: String,
    public val localGatewayVirtualInterfaceIds: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLocalGatewayVirtualInterfaceGroupResult):
            GetLocalGatewayVirtualInterfaceGroupResult = GetLocalGatewayVirtualInterfaceGroupResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            localGatewayId = javaType.localGatewayId(),
            localGatewayVirtualInterfaceIds = javaType.localGatewayVirtualInterfaceIds().map({ args0 ->
                args0
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
