@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of EC2 Local Gateway Virtual Interface Group identifiers.
 * @property localGatewayVirtualInterfaceIds Set of EC2 Local Gateway Virtual Interface identifiers.
 * @property tags
 */
public data class GetLocalGatewayVirtualInterfaceGroupsResult(
    public val filters: List<GetLocalGatewayVirtualInterfaceGroupsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val localGatewayVirtualInterfaceIds: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLocalGatewayVirtualInterfaceGroupsResult):
            GetLocalGatewayVirtualInterfaceGroupsResult = GetLocalGatewayVirtualInterfaceGroupsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            localGatewayVirtualInterfaceIds = javaType.localGatewayVirtualInterfaceIds().map({ args0 ->
                args0
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
