@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLocalGatewayVirtualInterface.
 * @property filters
 * @property id
 * @property localAddress Local address.
 * @property localBgpAsn Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the EC2 Local Gateway.
 * @property localGatewayId Identifier of the EC2 Local Gateway.
 * @property localGatewayVirtualInterfaceIds
 * @property peerAddress Peer address.
 * @property peerBgpAsn Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the peer.
 * @property tags
 * @property vlan Virtual Local Area Network.
 */
public data class GetLocalGatewayVirtualInterfaceResult(
    public val filters: List<GetLocalGatewayVirtualInterfaceFilter>? = null,
    public val id: String,
    public val localAddress: String,
    public val localBgpAsn: Int,
    public val localGatewayId: String,
    public val localGatewayVirtualInterfaceIds: List<String>,
    public val peerAddress: String,
    public val peerBgpAsn: Int,
    public val tags: Map<String, String>,
    public val vlan: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetLocalGatewayVirtualInterfaceResult):
            GetLocalGatewayVirtualInterfaceResult = GetLocalGatewayVirtualInterfaceResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            localAddress = javaType.localAddress(),
            localBgpAsn = javaType.localBgpAsn(),
            localGatewayId = javaType.localGatewayId(),
            localGatewayVirtualInterfaceIds = javaType.localGatewayVirtualInterfaceIds().map({ args0 ->
                args0
            }),
            peerAddress = javaType.peerAddress(),
            peerBgpAsn = javaType.peerBgpAsn(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vlan = javaType.vlan(),
        )
    }
}
