@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNatGateways.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of all the NAT gateway ids found.
 * @property tags
 * @property vpcId
 */
public data class GetNatGatewaysResult(
    public val filters: List<GetNatGatewaysFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNatGatewaysResult):
            GetNatGatewaysResult = GetNatGatewaysResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewaysFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
