@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclRules
 * @property additionalDetails
 * @property attachedTos
 * @property components
 * @property destinationVpcs
 * @property inboundHeaders
 * @property outboundHeaders
 * @property routeTableRoutes
 * @property securityGroupRules
 * @property sequenceNumber
 * @property sourceVpcs
 * @property subnets
 * @property transitGatewayRouteTableRoutes
 * @property transitGateways
 * @property vpcs
 */
public data class GetNetworkInsightsAnalysisForwardPathComponent(
    public val aclRules: List<GetNetworkInsightsAnalysisForwardPathComponentAclRule>,
    public val additionalDetails:
    List<GetNetworkInsightsAnalysisForwardPathComponentAdditionalDetail>,
    public val attachedTos: List<GetNetworkInsightsAnalysisForwardPathComponentAttachedTo>,
    public val components: List<GetNetworkInsightsAnalysisForwardPathComponentComponent>,
    public val destinationVpcs: List<GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc>,
    public val inboundHeaders: List<GetNetworkInsightsAnalysisForwardPathComponentInboundHeader>,
    public val outboundHeaders: List<GetNetworkInsightsAnalysisForwardPathComponentOutboundHeader>,
    public val routeTableRoutes: List<GetNetworkInsightsAnalysisForwardPathComponentRouteTableRoute>,
    public val securityGroupRules:
    List<GetNetworkInsightsAnalysisForwardPathComponentSecurityGroupRule>,
    public val sequenceNumber: Int,
    public val sourceVpcs: List<GetNetworkInsightsAnalysisForwardPathComponentSourceVpc>,
    public val subnets: List<GetNetworkInsightsAnalysisForwardPathComponentSubnet>,
    public val transitGatewayRouteTableRoutes:
    List<GetNetworkInsightsAnalysisForwardPathComponentTransitGatewayRouteTableRoute>,
    public val transitGateways: List<GetNetworkInsightsAnalysisForwardPathComponentTransitGateway>,
    public val vpcs: List<GetNetworkInsightsAnalysisForwardPathComponentVpc>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisForwardPathComponent):
            GetNetworkInsightsAnalysisForwardPathComponent =
            GetNetworkInsightsAnalysisForwardPathComponent(
                aclRules = javaType.aclRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentAclRule.Companion.toKotlin(args0)
                    })
                }),
                additionalDetails = javaType.additionalDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentAdditionalDetail.Companion.toKotlin(args0)
                    })
                }),
                attachedTos = javaType.attachedTos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentAttachedTo.Companion.toKotlin(args0)
                    })
                }),
                components = javaType.components().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentComponent.Companion.toKotlin(args0)
                    })
                }),
                destinationVpcs = javaType.destinationVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentDestinationVpc.Companion.toKotlin(args0)
                    })
                }),
                inboundHeaders = javaType.inboundHeaders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentInboundHeader.Companion.toKotlin(args0)
                    })
                }),
                outboundHeaders = javaType.outboundHeaders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentOutboundHeader.Companion.toKotlin(args0)
                    })
                }),
                routeTableRoutes = javaType.routeTableRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentRouteTableRoute.Companion.toKotlin(args0)
                    })
                }),
                securityGroupRules = javaType.securityGroupRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentSecurityGroupRule.Companion.toKotlin(args0)
                    })
                }),
                sequenceNumber = javaType.sequenceNumber(),
                sourceVpcs = javaType.sourceVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentSourceVpc.Companion.toKotlin(args0)
                    })
                }),
                subnets = javaType.subnets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentSubnet.Companion.toKotlin(args0)
                    })
                }),
                transitGatewayRouteTableRoutes = javaType.transitGatewayRouteTableRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentTransitGatewayRouteTableRoute.Companion.toKotlin(args0)
                    })
                }),
                transitGateways = javaType.transitGateways().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentTransitGateway.Companion.toKotlin(args0)
                    })
                }),
                vpcs = javaType.vpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponentVpc.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
