@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNetworkInsightsAnalysis.
 * @property alternatePathHints Potential intermediate components of a feasible path.
 * @property arn ARN of the selected Network Insights Analysis.
 * @property explanations Explanation codes for an unreachable path.
 * @property filterInArns ARNs of the AWS resources that the path must traverse.
 * @property filters
 * @property forwardPathComponents The components in the path from source to destination.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property networkInsightsAnalysisId
 * @property networkInsightsPathId The ID of the path.
 * @property pathFound Set to `true` if the destination was reachable.
 * @property returnPathComponents The components in the path from destination to source.
 * @property startDate Date/time the analysis was started.
 * @property status Status of the analysis. `succeeded` means the analysis was completed, not that a path was found, for that see `path_found`.
 * @property statusMessage Message to provide more context when the `status` is `failed`.
 * @property tags
 * @property warningMessage Warning message.
 */
public data class GetNetworkInsightsAnalysisResult(
    public val alternatePathHints: List<GetNetworkInsightsAnalysisAlternatePathHint>,
    public val arn: String,
    public val explanations: List<GetNetworkInsightsAnalysisExplanation>,
    public val filterInArns: List<String>,
    public val filters: List<GetNetworkInsightsAnalysisFilter>? = null,
    public val forwardPathComponents: List<GetNetworkInsightsAnalysisForwardPathComponent>,
    public val id: String,
    public val networkInsightsAnalysisId: String,
    public val networkInsightsPathId: String,
    public val pathFound: Boolean,
    public val returnPathComponents: List<GetNetworkInsightsAnalysisReturnPathComponent>,
    public val startDate: String,
    public val status: String,
    public val statusMessage: String,
    public val tags: Map<String, String>,
    public val warningMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisResult):
            GetNetworkInsightsAnalysisResult = GetNetworkInsightsAnalysisResult(
            alternatePathHints = javaType.alternatePathHints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisAlternatePathHint.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            explanations = javaType.explanations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisExplanation.Companion.toKotlin(args0)
                })
            }),
            filterInArns = javaType.filterInArns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisFilter.Companion.toKotlin(args0)
                })
            }),
            forwardPathComponents = javaType.forwardPathComponents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisForwardPathComponent.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            networkInsightsAnalysisId = javaType.networkInsightsAnalysisId(),
            networkInsightsPathId = javaType.networkInsightsPathId(),
            pathFound = javaType.pathFound(),
            returnPathComponents = javaType.returnPathComponents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponent.Companion.toKotlin(args0)
                })
            }),
            startDate = javaType.startDate(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            warningMessage = javaType.warningMessage(),
        )
    }
}
