@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclRules
 * @property additionalDetails
 * @property attachedTos
 * @property components
 * @property destinationVpcs
 * @property inboundHeaders
 * @property outboundHeaders
 * @property routeTableRoutes
 * @property securityGroupRules
 * @property sequenceNumber
 * @property sourceVpcs
 * @property subnets
 * @property transitGatewayRouteTableRoutes
 * @property transitGateways
 * @property vpcs
 */
public data class GetNetworkInsightsAnalysisReturnPathComponent(
    public val aclRules: List<GetNetworkInsightsAnalysisReturnPathComponentAclRule>,
    public val additionalDetails: List<GetNetworkInsightsAnalysisReturnPathComponentAdditionalDetail>,
    public val attachedTos: List<GetNetworkInsightsAnalysisReturnPathComponentAttachedTo>,
    public val components: List<GetNetworkInsightsAnalysisReturnPathComponentComponent>,
    public val destinationVpcs: List<GetNetworkInsightsAnalysisReturnPathComponentDestinationVpc>,
    public val inboundHeaders: List<GetNetworkInsightsAnalysisReturnPathComponentInboundHeader>,
    public val outboundHeaders: List<GetNetworkInsightsAnalysisReturnPathComponentOutboundHeader>,
    public val routeTableRoutes: List<GetNetworkInsightsAnalysisReturnPathComponentRouteTableRoute>,
    public val securityGroupRules:
    List<GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule>,
    public val sequenceNumber: Int,
    public val sourceVpcs: List<GetNetworkInsightsAnalysisReturnPathComponentSourceVpc>,
    public val subnets: List<GetNetworkInsightsAnalysisReturnPathComponentSubnet>,
    public val transitGatewayRouteTableRoutes:
    List<GetNetworkInsightsAnalysisReturnPathComponentTransitGatewayRouteTableRoute>,
    public val transitGateways: List<GetNetworkInsightsAnalysisReturnPathComponentTransitGateway>,
    public val vpcs: List<GetNetworkInsightsAnalysisReturnPathComponentVpc>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisReturnPathComponent):
            GetNetworkInsightsAnalysisReturnPathComponent =
            GetNetworkInsightsAnalysisReturnPathComponent(
                aclRules = javaType.aclRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentAclRule.Companion.toKotlin(args0)
                    })
                }),
                additionalDetails = javaType.additionalDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentAdditionalDetail.Companion.toKotlin(args0)
                    })
                }),
                attachedTos = javaType.attachedTos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentAttachedTo.Companion.toKotlin(args0)
                    })
                }),
                components = javaType.components().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentComponent.Companion.toKotlin(args0)
                    })
                }),
                destinationVpcs = javaType.destinationVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentDestinationVpc.Companion.toKotlin(args0)
                    })
                }),
                inboundHeaders = javaType.inboundHeaders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentInboundHeader.Companion.toKotlin(args0)
                    })
                }),
                outboundHeaders = javaType.outboundHeaders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentOutboundHeader.Companion.toKotlin(args0)
                    })
                }),
                routeTableRoutes = javaType.routeTableRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentRouteTableRoute.Companion.toKotlin(args0)
                    })
                }),
                securityGroupRules = javaType.securityGroupRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentSecurityGroupRule.Companion.toKotlin(args0)
                    })
                }),
                sequenceNumber = javaType.sequenceNumber(),
                sourceVpcs = javaType.sourceVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentSourceVpc.Companion.toKotlin(args0)
                    })
                }),
                subnets = javaType.subnets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentSubnet.Companion.toKotlin(args0)
                    })
                }),
                transitGatewayRouteTableRoutes = javaType.transitGatewayRouteTableRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentTransitGatewayRouteTableRoute.Companion.toKotlin(args0)
                    })
                }),
                transitGateways = javaType.transitGateways().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentTransitGateway.Companion.toKotlin(args0)
                    })
                }),
                vpcs = javaType.vpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentVpc.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
