@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidr
 * @property egress
 * @property portRanges
 * @property protocol
 * @property ruleAction
 * @property ruleNumber
 */
public data class GetNetworkInsightsAnalysisReturnPathComponentAclRule(
    public val cidr: String,
    public val egress: Boolean,
    public val portRanges: List<GetNetworkInsightsAnalysisReturnPathComponentAclRulePortRange>,
    public val protocol: String,
    public val ruleAction: String,
    public val ruleNumber: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsAnalysisReturnPathComponentAclRule):
            GetNetworkInsightsAnalysisReturnPathComponentAclRule =
            GetNetworkInsightsAnalysisReturnPathComponentAclRule(
                cidr = javaType.cidr(),
                egress = javaType.egress(),
                portRanges = javaType.portRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisReturnPathComponentAclRulePortRange.Companion.toKotlin(args0)
                    })
                }),
                protocol = javaType.protocol(),
                ruleAction = javaType.ruleAction(),
                ruleNumber = javaType.ruleNumber(),
            )
    }
}
