@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNetworkInsightsPath.
 * @property arn ARN of the selected Network Insights Path.
 * @property destination AWS resource that is the destination of the path.
 * @property destinationArn ARN of the destination.
 * @property destinationIp IP address of the AWS resource that is the destination of the path.
 * @property destinationPort Destination port.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property networkInsightsPathId
 * @property protocol Protocol.
 * @property source AWS resource that is the source of the path.
 * @property sourceArn ARN of the source.
 * @property sourceIp IP address of the AWS resource that is the source of the path.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetNetworkInsightsPathResult(
    public val arn: String,
    public val destination: String,
    public val destinationArn: String,
    public val destinationIp: String,
    public val destinationPort: Int,
    public val filters: List<GetNetworkInsightsPathFilter>? = null,
    public val id: String,
    public val networkInsightsPathId: String,
    public val protocol: String,
    public val source: String,
    public val sourceArn: String,
    public val sourceIp: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetNetworkInsightsPathResult):
            GetNetworkInsightsPathResult = GetNetworkInsightsPathResult(
            arn = javaType.arn(),
            destination = javaType.destination(),
            destinationArn = javaType.destinationArn(),
            destinationIp = javaType.destinationIp(),
            destinationPort = javaType.destinationPort(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsPathFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            networkInsightsPathId = javaType.networkInsightsPathId(),
            protocol = javaType.protocol(),
            source = javaType.source(),
            sourceArn = javaType.sourceArn(),
            sourceIp = javaType.sourceIp(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
