@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPrefixList.
 * @property cidrBlocks List of CIDR blocks for the AWS service associated with the prefix list.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the selected prefix list.
 * @property prefixListId
 */
public data class GetPrefixListResult(
    public val cidrBlocks: List<String>,
    public val filters: List<GetPrefixListFilter>? = null,
    public val id: String,
    public val name: String,
    public val prefixListId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetPrefixListResult):
            GetPrefixListResult = GetPrefixListResult(
            cidrBlocks = javaType.cidrBlocks().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.GetPrefixListFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            prefixListId = javaType.prefixListId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
